# -*- Mode: Python; tab-width: 4 -*-

"Find completions for attribute and object names"

# TODO: sys.path module-name completion (as a separate function)
# FIXME: use hasattr!

import regex
import string
import types

def remove_duplicates (l):
	l.sort()
	r = []
	for x in l:
		if (not r) or (r[-1] != x):
			r.append (x)
	return r

def get_children (thing):
	"generic: get the child attributes of <thing>"
	if type(thing) == types.DictionaryType:
		return thing.keys()
	elif type(thing) == types.InstanceType:
		return remove_duplicates (
			thing.__dict__.keys() + dir(thing.__class__)
			)
	else:
		return dir(thing)

def get_child (thing, name):
	"generic: get an attribute of <thing>"
	if type(thing) == type({}):
		return thing[name]
	else:
		return getattr (thing, name)

def factor_common_prefix (names, start=0):
	"factor out a common prefix from <names>, beginning with character <start>"

	prefix = ''

	if names:
		m = min (map (len, names))
		for x in range (start, m):
			chars = map (lambda a,x=x: a[x], names)
			if chars and filter (lambda a,ch=chars[0]: a != ch, chars):
				break
			else:
				prefix = prefix + chars[0]

	return prefix

def completions (part, thing):

	"find all completions of the symbol <part> in object <thing>"

	lp = len(part)

	fronts = []

	while '.' in part:
		i = string.index (part, '.')
		front = part[:i]
		fronts.append (front)
		thing = get_child (thing, front)
		part = part[i+1:]

	syms = get_children (thing)
	matches = []

	if part:
		r = regex.compile (part)
		for sym in syms:
			if r.match (sym) > 0:
				matches.append (sym)
	else:
		matches = syms

	result = []

	for match in matches:
		result.append (
			string.join (fronts + [match], '.')
			)

	if len(matches) > 1:
		return factor_common_prefix (result, start=lp), result
	else:
		return '', result
