# -*- Mode: Python; tab-width: 4 -*-

# currently just some utility functions for turning echo on/off.

# from <wincon.n>

#
#  Input Mode flags:
#

ENABLE_PROCESSED_INPUT = 0x0001
ENABLE_LINE_INPUT      = 0x0002
ENABLE_ECHO_INPUT      = 0x0004
ENABLE_WINDOW_INPUT    = 0x0008
ENABLE_MOUSE_INPUT     = 0x0010

# from <winbase.h>
STD_INPUT_HANDLE    = -10
STD_OUTPUT_HANDLE   = -11
STD_ERROR_HANDLE    = -12

import struct

import windll

kernel32 = windll.module ('kernel32')

def set_echo (yesno):
	console_handle = kernel32.GetStdHandle (STD_INPUT_HANDLE)
	mode = windll.membuf(4)
	kernel32.GetConsoleMode (console_handle, mode)
	mode_val = struct.unpack ('l', mode.read())[0]
	if yesno:
		mode_val = mode_val | ENABLE_ECHO_INPUT
	else:
		mode_val = mode_val & ~ENABLE_ECHO_INPUT
	kernel32.SetConsoleMode (console_handle, mode_val & ~ENABLE_MOUSE_INPUT)

def test ():
	print 'Enter a line, then hit <return>'
	try:
		set_echo (0)
		line = raw_input()
	finally:
		set_echo (1)
	return line

if __name__ == '__main__':
	test()
