# -*- Mode: Python; tab-width: 4 -*-

import mvc_edit
import layout
import winwin
import mvc_button
import static
import sys

# currently supported items:
# text - edit
# password - password edit

# ad = auto_dialog (
# 	('edit', 'Username:'),
# 	('password', 'Password:')
# 	)

# and then add OK/Cancel

class auto_dialog (layout.vbox):

	style = winwin.WS_THICKFRAME
	ext_style = winwin.WS_EX_DLGMODALFRAME

	def create (*args):
		self = apply (layout.vbox.create, args)
		self.tabstops = []
		self.add (self.GLUE)

		for item in self.items:
			h = layout.hbox(parent=self).create()
			kind = item[0]
			if kind == 'edit':
				label = item[2]
				h.add (h.GLUE)
				s = static.static_text_component (text=label, parent=h).create()
				h.add (s)
				h.add (h.spacer (10,10))
				e = mvc_edit.edit_control (h, '', observer=self).create()
				h.add (e)
				h.add (h.spacer (10,10))
				self.tabstops.append ((e.model, e))
				for x in s,e,h:
					x.show_window()
			self.add (h, 1)
			self.add (self.GLUE)

		h = layout.hbox(parent=self).create()
		ob = mvc_button.make_text_button ('OK', h).create()
		cb = mvc_button.make_text_button ('Cancel', h).create()

		for x in (h.GLUE, ob, h.spacer (10,10), cb, h.GLUE):
			h.add (x)

		ob.model.add_view (self)
		cb.model.add_view (self)

		self.add (h)
		self.add (self.GLUE)

		for x in h, ob, cb, self:
			x.show_window()

		return self

	def notify (self, model, hint):
		print model, hint
		if hint == 'tab':
			ts = self.tabstops
			for i in range(len(ts)):
				m, w = ts[i]
				if model == m:
					ts[(i+1)%len(ts)][1].set_focus()
		elif hint == 'pressed':
			self.done (model.label=='OK')
		elif hint == 'enter':
			self.done (1)

	def done (self, ok):
		d = {}
		ts = self.tabstops
		for i in range(len(self.items)):
			name = self.items[i][1]
			d[name] = ts[i][1].get_text()
		self.values = d
		self.destroy_window()
		del self.tabstops
		del self.items

def test():
	w = auto_dialog (
		'Answer Me These Questions Three',
		w=450, h=180,
		items = (
			('edit', 'name', 'What is Your Name?'),
			('edit', 'quest', 'What is Your Quest?'),
			('edit', 'color', 'What is Your Favorite Color?'),
			)
		).create()
	w.show_window()
	return w

if __name__ == '__main__':
	import msgloop
	w = test()
	msgloop.go()
	for k,v in w.values.items():
		print k, '=', v
