# -*- Mode: Python; tab-width: 4 -*-

# test of buffered drawing (i.e., draw into a cached bitmap)

#from dyn_win32 import windc, msgloop, wingdi, winwin, wintypes, winfont
import windc
import msgloop
import wingdi
import winwin
import wintypes
import winfont

SPLIT_WORD = winwin.SPLIT_WORD

class double_buffered_window (winwin.python_window):

	def WM_DESTROY (self, wparam, lparam):
		del double_buffered_window.pen_cache
 		winwin.user32.PostQuitMessage (0)

	dirty = 0
	bitmap = 0
	style = winwin.WS_OVERLAPPEDWINDOW

	def forget_bitmap (self):
		if self.bitmap:
			self.bitmap.delete()
			self.bitmap = 0

	def WM_CHAR (self, wparam, lparam):
		# ASCII char in wparam
		ch = chr (wparam)

		if ch == 'b':
			# bitmap
			self.WM_PAINT, self.WM_ERASEBKGND = self.bitmap_paint, self.bitmap_erasebkgnd
		elif ch == 'd':
			# direct
			self.WM_PAINT, self.WM_ERASEBKGND = self.direct_paint, self.direct_erasebkgnd
		elif ch == 't':
			self.draw_something = self.draw_target
		elif ch == 'g':
			self.draw_something = self.draw_grid
		elif ch == 'q':
			self.WM_DESTROY (0,0)

		self.invalidate()

		return 1

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		self.forget_bitmap()
		self.invalidate_rect (0)

	def invalidate (self):
		self.dirty = 1
		self.invalidate_rect (0)

	def bitmap_erasebkgnd (self, wparam, lparam):
		# we handle the background-erasing
		return 1

	def direct_erasebkgnd (self, wparam, lparam):
		return 0

	def direct_paint (self, wparam, lparam):
		w, h = self.size
		dc = self.begin_paint()
		dc.set_bk_color()
		self.draw_something (dc, w, h)
		self.end_paint()

	def bitmap_paint (self, wparam, lparam):

		w, h = self.size
		try:
			dc = self.begin_paint()

			# create a memory device context
			mdc = dc.create_compatible_dc()

			old_bm = 0

			if not self.bitmap or self.dirty:

				if self.dirty:
					bm = self.bitmap
				else:
					bm = dc.create_compatible_bitmap (w, h)

				# select this bitmap into the memory DC
				old_bm = mdc.select_object (bm)

				# draw into the memory dc (and thus the bitmap)

				# fill with the background color
				mdc.fill_rect (
					(0,0,w,h),
					winwin.user32.GetSysColorBrush (windc.COLOR_WINDOW)
					)

				self.draw_something (mdc, w, h)

				self.dirty = 0
				self.bitmap = bm

			if self.bitmap:
				if not old_bm:
					old_bm = mdc.select_object (self.bitmap)

				dc.bit_blt ((0,0), (w,h), mdc, (0,0), wingdi.SRCCOPY)

			if old_bm:
				mdc.select_object (old_bm)

			mdc.delete_dc ()

		finally:
			self.end_paint()

		return 1

	def draw_grid (self, dc, w, h):
		# draw a pattern
		dc.select_object (self.get_pen ((0, 0, 0xff)))
		for x in range (0, w, 5):
			dc.move_to ((x, 0))
			dc.line_to ((x, h))

		dc.select_object (self.get_pen ((0xff, 0, 0)))
		for y in range (0, h, 5):
			dc.move_to ((0, y))
			dc.line_to ((w, y))


	def draw_target (self, dc, w, h):
		mr = max (w, h) / 2
		cx, cy = w/2, h/2
		dc.select_object (self.get_pen ((0,0x80,0x80)))
		for r in range (0, mr, 5):
			dc.arc ((cx-r,cy-r,cx+r,cy+r),(0,0),(0,0))

	WM_PAINT = direct_paint
	WM_ERASEBKGND = direct_erasebkgnd
	draw_something = draw_target

	pen_cache = {}

	def get_pen (self, color):
		if not self.pen_cache.has_key (color):
			r,g,b = color
			pen = wingdi.pen (red=r,green=g,blue=b).create()
			self.pen_cache[color] = pen
			return pen
		else:
			return self.pen_cache[color]

def test ():
	w = double_buffered_window ('Double-Buffered Test').create()
	w.show_window()
	return w

if __name__ == '__main__':
	import msgloop
	test()
	msgloop.go()
