# -*- Mode: Python; tab-width: 4 -*-
# Author: Sam Rushing <rushing@nightmare.com>

import windll
import structob

cstring = windll.cstring

user32 = windll.module ('user32')
kernel32 = windll.module ('kernel32')

def get_windows_directory ():
	buffer = cstring ('', 64)
	length = kernel32.GetWindowsDirectory (
		buffer,
		len(buffer)
		)
	return buffer.trunc()

memstat = structob.Oracle (
	'memory status structure',
	'Nllllllll',
	('Length',
	 'MemoryLoad',
	 'TotalPhys',
	 'AvailPhys',
	 'TotalPageFile',
	 'AvailPageFile',
	 'TotalVirtual',
	 'AvailVirtual')
	)

def global_memory_status():
	buffer = windll.membuf (memstat.size)
	result = kernel32.GlobalMemoryStatus (buffer.address())
	dict, size = memstat.unpack (buffer.read())
	memstat.describe (dict)

def demo ():

	# --------------------------------------------------
	# calling a system function
	# --------------------------------------------------
	# GetDoubleClickTime takes no arguments and returns an integer
	dct = user32.GetDoubleClickTime ()
	# now let the user know what it is with a message box
	user32.MessageBox (
		0,
		cstring ('Your double-click time is set to %d' % dct),
		cstring ('foreign function interface demo'),
		0
		)
	# --------------------------------------------------
	# calling a random dll
	# --------------------------------------------------
	# make some noise
	import os
	# first, get the system path and see if 'chord.wav' is in there.
	windows_directory = get_windows_directory()
	noise_file = os.path.join (windows_directory, 'chord.wav')
	# try to load the multimedia dll
	winmm = windll.module ('winmm')
	if os.path.isfile (noise_file) and winmm:
		winmm.mciSendString (cstring ('play %s' % noise_file), 0, 0, 0)

	# --------------------------------------------------
	# filling in a structure with a windows system call
	# --------------------------------------------------
	# print out the global memory status
	global_memory_status()

if __name__ == '__main__':
	demo()
