# -*- Mode: Python; tab-width: 4 -*-

import python_interpreter

option_tree = [
	'Top-Level Menu',
	['File', 'Open...', 'Execute...', 'Exit'],
	['Window', 'New', 'Close', 'Flush Output'],
	['Help', 'About']
	]

import mvc_button
import layout
import winwin
import mvc_model_tree
import static

import sys

class python_frame (layout.border_container):

	def create (*args):
		self = apply (layout.border_container.create, args)
		mt = mvc_model_tree.make_model_tree (option_tree)
		mt.add_view_all (self)
		mb = mt.as_menu_bar (parent=self).create()
		pw = python_interpreter.python_interpreter_component (parent=self).create()
		self.add (mb, 'north')
		self.add (pw, 'center')
		self.python_window = pw
		self.set_window_text (
			'Interpreter #%d' % (
				python_interpreter.python_interpreter_window.counter
				)
			)
		return self

	def WM_SETFOCUS (self, wparam, lparam):
		# always move focus to the interpreter window
		self.python_window.set_focus()

	def notify (self, model, hint):
		if hint == 'pressed' and model.pressed == 1:
			self.menu_selection (model)

	def menu_selection (self, model):
		label = model.label
		if label == 'About':
			about_frame(
				'Dynwin Interpreter Demo',
				w = 500, h = 150
				).create().show_window()
		elif label == 'Exit':
			self.post_quit_message()
		elif label == 'New':
			f = python_frame().create()
			f.show_window()
			f.python_window.prompt()
		elif label == 'Close':
			self.destroy_window()
		elif label == 'Flush Output':
			self.python_window.flush_output()
			self.python_window.prompt()
		else:
			if not model.cascade:
				warn ('not yet implemented')
			return
		model.pressed = 0

def warn (m):
	winwin.user32.MessageBox (0, winwin.cstring (m), winwin.cstring ("DynWin"), 0)

about_text = """\
by Sam Rushing, July 1998.
Python %s on Win32""" % (sys.version)

class about_frame (layout.vbox):

	style = winwin.WS_THICKFRAME
	ext_style = winwin.WS_EX_DLGMODALFRAME

	def create (*args):
		self = apply (layout.vbox.create, args)

		h = layout.hbox (parent=self).create()

		# model
		okm = mvc_button.push_button_model (label='OK')
		okm.add_view (self)
		# view
		okb = mvc_button.text_button (parent=h).create()
		okb.set_model (okm)
		
		h.add (h.GLUE)
		h.add (okb)
		h.add (h.GLUE)

		# static
		sw = static.static_text_component (parent=self).create()
		sw.set_text (about_text)

		self.add (self.GLUE)
		self.add (sw)
		self.add (self.GLUE)
		self.add (h)
		self.add (self.GLUE)

		for w in h,okb,sw,self:
			w.show_window()

		return self

	def notify (self, model, hint):
		if model.pressed:
			self.destroy_window()

def go():
	f = python_frame().create()
	f.show_window()
	f.python_window.prompt()
	return f

if __name__ == '__main__':
	import msgloop
	f = go()
	msgloop.go()
