# -*- Mode: Python; tab-width: 4 -*-

# Demonstration of callback functions (a la gencb) and the calldll module.
# Implements a minimal windows 'skeleton' application -
# creates a window class, a window, and starts up a message loop.

import calldll
import windll
import winmesg
import npstruct

kernel32 = windll.module ('kernel32')
user32	 = windll.module ('user32')
gdi32	 = windll.module ('gdi32')

# are we running in the console or windows subsystem?
title = windll.cstring ('', 64)
title_len = kernel32.GetConsoleTitle (title, len(title))
if title_len:
	console = 1
else:
	console = 0
del title

def window_procedure (hwnd, message, wparam, lparam):
	reprm = repr(message)
	if user32.InSendMessage():
		sm = 'S'
	else:
		sm = ' '

	if winmesg.db.has_key (reprm):
		print '%-30s %08x %08x %c' % (winmesg.db[reprm], wparam, lparam, sm)
	else:
		print '%-30x %08x %08x %c' % (message, wparam, lparam, sm)

	if message == win32con.WM_DESTROY:
		if console:
			user32.PostQuitMessage (0)
	else:
		return user32.DefWindowProc (hwnd, message, wparam, lparam)
	return 0

import gencb

# generate a callback procedure that wraps the python function
# <window_procedure>.  The address of this procedure will be
# placed into the lpfnWndProc slot of the wndclassex structure.

wp_cb = gencb.generated_callback ('llll', window_procedure)

from oracle import Oracle

wndclassex = Oracle (
	'window class information',
	'Nllllllllllll',
	('cbSize',
	 'style',
	 'lpfnWndProc',
	 'cbClsExtra',
	 'cbWndExtra',
	 'hInstance',
	 'hIcon',
	 'hCursor',
	 'hbrBackground',
	 'lpszMenuName',
	 'lpszClassName',
	 'hIconSm')
	)

import winwin
import winclass
import windc

IDC_ARROW = 32512L
CW_USEDEFAULT = 0x80000000L
HWND_DESKTOP = 0L

# ==================================================
# build a WndClassEx structure.
# ==================================================

wc = wndclassex.new()
# get the module handle for this program
module_handle = kernel32.GetModuleHandle (0)
my_class_name = windll.cstring ('cbdemo window class')
edit_class_name = windll.cstring ('Edit')
header_class_name = windll.cstring ('SysHeader32')

# fill it in.
wc['hInstance']		= module_handle
wc['lpszClassName']	= my_class_name.address()
wc['lpfnWndProc']	= wp_cb.address
wc['style']			= 0					# default style
wc['cbSize']		= wndclassex.size
wc['hIcon']			= user32.LoadIcon (0, winclass.IDI_APPLICATION)
wc['hIconSm']		= user32.LoadIcon (0, winclass.IDI_WINLOGO)
wc['hCursor']		= user32.LoadCursor (0, winclass.IDC_ARROW)
wc['lpszMenuName']	= 0
wc['cbClsExtra']	= 0
wc['cbWndExtra']	= 0
wc['hbrBackground']	= gdi32.GetStockObject (windc.COLOR_BACKGROUND)

wc_mb = windll.cstring (wndclassex.pack (wc))

print 'Registering window class...'
print user32.RegisterClassEx (wc_mb.address())

window_title = windll.cstring ('My cbdemo Window')

import winerror

# need to automate this.
def safe_long (n):
	return (int(n>>1)<<1)+int(n&1)

def create_window (parent=0, cla=my_class_name.address()):
	print 'Creating window...'
	hwnd = user32.CreateWindowEx (
		0,
		cla,
		window_title.address(),
		winwin.WS_OVERLAPPEDWINDOW,
		safe_long(winwin.CW_USEDEFAULT),
		safe_long(winwin.CW_USEDEFAULT),
		safe_long(winwin.CW_USEDEFAULT),
		safe_long(winwin.CW_USEDEFAULT),
		parent,
		0,
		module_handle,
		0)
	if not hwnd:
		print 'CreateWindow failed: %s' % winerror.get_error_string()
	else:
		print 'hwnd: %08x' % hwnd
		print 'ShowWindow... %08x' % user32.ShowWindow (hwnd, winwin.SW_SHOWDEFAULT)
		print 'UpdateWindow... %08x' % user32.UpdateWindow (hwnd)
	return hwnd

import structob

class MSG (structob.struct_object):
	oracle = structob.Oracle (
		'windows message',
		'Nlllllll',
		('hwnd',
		 'message',
		 'wParam',
		 'lParam',
		 'time',
		 'x',
		 'y')
		)

msg = MSG()

# A message loop, all in Python!
def go():
	while user32.GetMessage (msg, 0, 0, 0):
		user32.TranslateMessage (msg)
		user32.DispatchMessage (msg)

def demo():
	# no need to start a message loop if we're running as
	# a windows program... there's already one running.
	if create_window() and console:
		go()

if __name__ == '__main__':
	demo()
