# -*- Mode: Python; tab-width: 4 -*-

import windll
cstring = windll.cstring

kernel32 = windll.module ('kernel32')
user32	 = windll.module ('user32')
gdi32	 = windll.module ('gdi32')

import wingdi
import winfont
import wintypes
import windc
import winwin
import winscroll

# =========================================================================
# Test it all out...
# =========================================================================

def SPLIT_WORD (x):
	return (x&0xffff, (x>>16))

class test_window (winscroll.scrollable_window):
	# some of these should be per-window.
	brush	= wingdi.brush (blue=128, green=128).create()
	font	= winfont.font ('Arial', height=24).create()
	region	= wintypes.RGNDATA()

	def WM_SIZE (self, wparam, lparam):
		print 'WM_SIZE x:%d  y:%d' % (SPLIT_WORD (lparam))

	def WM_DESTROY (self, wparam, lparam):
		# need an interface for this.
		del winwin.window_map[self.hwnd]
		user32.PostQuitMessage (0)

	def WM_PAINT (self, wparam, lparam):
		# find out what sort of update region we're talking about.
		hrgn = gdi32.CreateRectRgn (0,0,1,1)
		region_type = user32.GetUpdateRgn (self.hwnd, hrgn, 0)
		rects = []
		if region_type == wintypes.RGNDATA.SIMPLEREGION:
			pass
		elif region_type == wintypes.RGNDATA.COMPLEXREGION:
			retval = gdi32.GetRegionData (
				hrgn,
				self.region.real_size,
				self.region.address()
				)
			if retval == 0:
				print 'GetRegionData failed!'
			elif retval > self.region.real_size:
				print 'GetRegionData needed a bigger buffer (%d bytes)' % retval
			else:
				rects = self.region.rects
		else:
			return 0
		dc = self.begin_paint()
		try:
			print 'smm', dc.set_map_mode (windc.MM_ISOTROPIC)
			print 'sve', dc.set_viewport_ext (1000, 1000)
			print 'w org, ext', dc.get_window_org(), dc.get_window_ext()
			print 'v org, ext', dc.get_viewport_org(), dc.get_viewport_ext()
			# rc_paint bounds the entire update region.
			# if we get rects above, we should use them instead.
			if not rects:
				rects = [self.paintstruct.rc_paint]
			print rects
			dc.set_bk_color()
			dc.select_object (self.font)
			dc.text_out ((10,10), cstring ('Howdy!'))
			dc.fill_rect ((50,50,100,100), self.brush)
		finally:
			self.end_paint()

# ===========================================================================
# Message Loop
# ===========================================================================

import wintypes

class message_loop:

	def __init__ (self):
		self.msg = wintypes.MSG()		

	def go (self):
		while user32.GetMessage (self.msg, 0, 0, 0):
			user32.TranslateMessage (self.msg)
			user32.DispatchMessage (self.msg)

def go():
	message_loop().go()

def test():
	import winclass
	my_class = winclass.window_class (
		'winwin demo',
		winwin.window_procedure
		).register()
	my_window = test_window (
		'my window',
		'winwin demo',
		x=10,y=10,w=300,h=200
		).create()
	my_window.show_window (winwin.SW_SHOW)
	my_window.update_window()
	go()
	windll.dump_module_info()

if __name__ == '__main__':
	test()
