# -*- Mode: Python; tab-width: 4 -*-

#from dyn_win32 import windc, msgloop, wingdi, winwin, wintypes, winfont
import windc
import msgloop
import wingdi
import winwin
import wintypes
import winfont

import profile

def SPLIT_WORD (x):
	return (x&0xffff, (x>>16))

class path_test_window (winwin.python_window):

	def WM_DESTROY (self, wparam, lparam):
		del path_test_window.pen_cache
 		winwin.user32.PostQuitMessage (0)

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		self.invalidate_rect (0)

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()

		thing_font = winfont.font (
			'Arial',
			height=120,
			weight=winfont.FW_BOLD
			).create()

		dc.select_object (thing_font)
		dc.set_bk_mode (windc.TRANSPARENT)
		dc.set_text_align (wingdi.TA_CENTER | wingdi.TA_BASELINE)
		w, h = self.size

		dc.begin_path ()
		dc.text_out ((w/2, h/2), 'Slithy Toves!')
		dc.end_path ()

		blue_pen = self.get_pen ((0,0,255))
		red_pen = self.get_pen ((255,0,0))

		dc.select_object (blue_pen)
		dc.stroke_path()

		dc.begin_path ()
		dc.text_out ((w/2, h/2), 'Slithy Toves!')
		dc.end_path ()

		dc.select_clip_path (windc.RGN_COPY)
		
		for i in range(0,500,5):
			dc.select_object (blue_pen)
			dc.arc (
				(w/2-i,h/2-i,w/2+i,h/2+i),
				(0,0),
				(0,0)
				)
			dc.select_object (red_pen)
			dc.arc (
				(w/2-i,h/2-i+50,w/2+i,h/2+i+50),
				(0,0),
				(0,0)
				)


		self.end_paint()
		return 1

	pen_cache = {}

	def get_pen (self, color):
		if not self.pen_cache.has_key (color):
			r,g,b = color
			pen = wingdi.pen (red=r,green=g,blue=b).create()
			self.pen_cache[color] = pen
			return pen
		else:
			return self.pen_cache[color]

w = path_test_window ('Path Test')
w.create()
w.show_window()

msgloop.go()
