# -*- Mode: Python; tab-width: 4 -*-

import windll
import wingdi

cstring = windll.cstring
gdi32 = windll.module ('gdi32')

def test():
	# create a printer dc
	dc = gdi32.CreateDC (
		0,
		cstring('HP DeskJet 820C Series Printer'),
		0,
		0
		)
	
	print 'dc=',dc
	di = wingdi.DOCINFO()
	# tricky... need to look at this.
	di.cb_size = di.size
	doc_name = cstring ('testing')
	di.doc_name = doc_name.address()
	di.output = 0
	di.datatype = 0
	di.type = 0

	di.describe()

	gdi32.StartDoc (dc, di)
	
	gdi32.StartPage (dc)
	print 'drawing...'
	# draw some stuff...
	gdi32.MoveToEx (dc, 10, 10, 0)
	hilbert (
		10.0,10.0,2048.0,0.0,0.0,2048.0,0,6,
		lambda x,y,dc=dc,g=gdi32: g.LineTo (dc, x,y)
		)

	gdi32.EndPage (dc)
	print 'EndDoc(), DeleteDC()'
	gdi32.EndDoc (dc)
	gdi32.DeleteDC (dc)

def hilbert (x0, y0, xis, xjs, yis, yjs, n, d, draw):
	# x0 and y0 are the coordinates of the bottom left corner
	# xis & xjs are the i & j components of the unit x vector this frame
	# similarly yis and yjs
	if n >= d:
		draw (x0+(xis+yis)/2, y0+(xjs+yjs)/2)
	else:
		hilbert(x0, y0, yis/2, yjs/2, xis/2, xjs/2, n+1, d, draw)
		hilbert(x0+xis/2, y0+xjs/2 ,xis/2, xjs/2, yis/2, yjs/2, n+1, d, draw)
		hilbert(x0+xis/2+yis/2, y0+xjs/2+yjs/2, xis/2, xjs/2, yis/2, yjs/2,n+1, d, draw)
		hilbert(x0+xis/2+yis, y0+xjs/2+yjs, -yis/2,-yjs/2, -xis/2, -xjs/2,n+1, d, draw)
