# -*- Mode: Python; tab-width: 4 -*-
# 	$Id: pysyntax.py,v 1.1 1995/10/20 18:58:47 rushing Exp $

import regex
import regsub
import string

class python_syntaxer:

	color_dict = {
		'def':(0,0,255),
		'import':(255,0,255),
		'comment':(128,0,0),
		'keyword':(0,0,128),
		'string':(0,128,0)
		}

	string_regex = regex.compile ('\(\("[^"]*"\)\|'+ "\('[^']*'\)\)")

	comment_regex = regex.compile ('\(#.*$\)')

	def_regex = regex.compile ('[ \t]*\(\(\(def\)\|\(class\)\)[ \t][^ \t:]*\).*')

	keyword_list = [
		"access","and","break","continue",
		"del","elif","else","except",
		"exec","finally","for","from",
		"global","if","import","in",
		"is","lambda","not","or",
		"pass","print","raise","return",
		"try","while","def","class","self"
		]

	keyword_regex = regex.compile (
		'\(\<%s\>\)' % (
			string.joinfields (
				keyword_list, '\>\|\<'
				)
			)
		)


	def format (self, line):
		# comments first
		fline = self.format_list (self.comment_regex, self.color_dict['comment'], [line])
		# then strings
		fline = self.format_list (self.string_regex, self.color_dict['string'], fline)
		# defuns
		fline = self.format_list (self.def_regex, self.color_dict['def'], fline)
		# finally keywords
		fline = self.format_list (self.keyword_regex, self.color_dict['keyword'], fline)
		return fline

	def format_list (self, reg, color, part_list):
		# this will give us a list of formatted lists
		flist = map (
			lambda x,s=self,r=reg,c=color:
			s.split_by_reg (r,c,x),
			part_list
			)
		# now flatten the list back out
		return reduce (lambda a,b:a+b, flist)

	# modeled after regsub.split
	def split_by_reg (self, reg, color, part):
		# already converted part?
		if type(part) != type(''):
			return [part]
		res = []
		start = next = 0
		while reg.search (part, next) >= 0:
			# get the start and end of the first group
			l,r = reg.regs[1]
			res.append (part[start:l])
			res.append (color,part[l:r])
			start = next = r
		res.append (part[start:])
		return res
			

if __name__ == '__main__':
	try:
		1 + ''
	except:
		import sys
		filename = sys.exc_traceback.tb_frame.f_code.co_filename
	lines = open (filename).readlines()
	s = python_syntaxer()
	lines = map (s.format, lines)
	for line in lines:
		print line
