# -*- Mode: Python; tab-width: 4 -*-

import quadtree
import winwin
import random
import windll

import windc
gdi32 = windll.module ('gdi32')

class box:
	def __init__ (self, rect, up=1):
		self.rect = rect
		self.up = up

	def get_rect (self):
		return self.rect

	def do_paint (self, dc):
		dc.draw_3d_box (self.rect, self.up)
		#dc.rectangle (self.rect)
		#print self.rect

class demo (winwin.python_window):

	style = winwin.WS_OVERLAPPEDWINDOW

	def populate (self, nrects=100, ww=2000):
		qt = quadtree.quadtree ((0, 0, ww, ww))
		for i in range (nrects):
			w = random.randint (10, 100)
			h = random.randint (10, 100)
			x = random.randint (0, ww)
			y = random.randint (0, ww)
			if x + w > ww:
				x = x - w
			if y + h > ww:
				y = y - h
			
			qt.insert (
				box (
					(x, y, x+w, y+h),
					random.randint (0,1)
					)
				)
		self.quadtree = qt

	def WM_PAINT (self, wparam, lparam):
		rects = self.get_clip_rects()
		dc = self.begin_paint()
		for rect in rects:
			self.quadtree.search_apply (rect, lambda x,dc=dc: x.do_paint (dc))
		self.end_paint()

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		clip = dc.get_clip_box()
		self.quadtree.search_apply (clip, lambda x,dc=dc: x.do_paint (dc))
		self.end_paint()

	def WM_ERASEBKGND (self, wparam, lparam):
		return 0

	def WM_DESTROY (self, wparam, lparam):
		self.post_quit_message()

def test ():
	w = demo ('quadtree demo').create()
	w.populate (200)
	w.show_window()

if __name__ == '__main__':
	import msgloop
	test()
	msgloop.go()
