# -*- Mode: Python; tab-width: 4 -*-

import string

import msgloop
import winclass
import windc
import windll
import winfont
import wingdi
import winwin
import winscroll
import wintypes

windows = []

# returns LOWORD, HIWORD
def SPLIT_WORD (x):
	return (x&0xffff, (x>>16))

class source_window (winscroll.scrollable_window):

	def WM_PAINT (self, wparam, lparam):
		try:
			dc = self.begin_paint()

			dc.select_object (self.font)
			dc.set_bk_color()
			dc.set_bk_mode (windc.TRANSPARENT)
			dc.set_text_align (wingdi.TA_UPDATECP)

			l,t,r,b = dc.get_clip_box()

			# determine the range of lines we need to draw

			fh = self.font_height
			first = t / fh
			last  = b / fh
			if b % fh:
				last = last + 1

			for i in range (first, last):
				self.draw_line (dc, i*fh, i)

		finally:
			self.end_paint()

	font_height = 16

	def draw_line (self, dc, y, index):
		dc.move_to ((0, y))
		for part in self.lines[index]:
			if type(part) == type(''):
				dc.set_text_color ((0,0,0))
				text = part
			else:
				color, text = part
				dc.set_text_color (color)
				
			dc.text_out ((0,0), text)

		px, py = dc.move_to_ex ((0,0))
		if px > self.widest_line:
			self.widest_line = px
			self.set_virtual_window ((0,0,self.widest_line, self.font_height * len (self.lines)))

	font = winfont.font ('Courier New', height=font_height).create()

	def WM_SIZE (self, wparam, lparam):
		w, h = SPLIT_WORD (lparam)
		self.width = w
		self.height = h
		self.widest_line = 10

		self.set_virtual_window ((
			0,
			0,
			self.widest_line,
			self.font_height * len (self.lines)
			))

		self.set_scroll_values (None, self.font_height)

	def WM_DESTROY (self, wparam, lparam):
		global windows
		windows.remove (self)
		if not windows:
			winwin.user32.PostQuitMessage (0)

# ===========================================================================

import pysyntax
sf = pysyntax.python_syntaxer()

def frob_line (line):
	return string.join (string.split (line[:-1], '\t'), '    ')

def make_source_window (filename):
	lines = map (frob_line, open (filename).readlines())
	lines = map (sf.format, lines)
	w = source_window (filename)
	w.lines = lines
	w.create()
	w.show_window()
	return w

import sys
	
if len (sys.argv) < 2:
	files = ['synhlt.py']
else:
	files = sys.argv[1:]

for file in files:
	windows.append (make_source_window (file))

msgloop.go()
source_window.font.delete()
windll.dump_module_info()
