# -*- Mode: Python; tab-width: 4 -*-

import winwin
import winfont

import dynscroll
import mvc
import mvc_scrollbar
import mvc_seq_win

# Don't read this file, it wrongly and confusingly combines two
# conceptual errors into a disgusting mess.  But it works, so run it
# if you must.

# This should of course be much simpler.  We still need to create a
# 'sequence-view' frame class that automatically ties on the
# scrollbar, etc...

class font_viewer (mvc_seq_win.sequence_window):

	def draw_line (self, dc, index):
		fh = self.line_height
		x = 4
		y = index * fh
		dc.select_object (self.number_font)
		dc.text_out ((x,y), '%03x' % index)
		
		dc.select_object (self.font)
		x = x + (4 * fh)
		dc.text_out ((x,y), chr(index))

	def begin_paint (self, paintstruct=None):
		dc = winwin.python_window.begin_paint (self, paintstruct)
		self.prepare_dc (dc)
		return dc

	def prepare_dc (self, dc):
		dc.set_window_org (0, self.scroll_model.position * self.line_height)

	last_scroll_position = 0

	def notify (self, vm, hint):
		ly = self.last_scroll_position
		ny = vm.position
		dy = ly - ny
		self.scroll_window (0, (dy * self.line_height))
		self.last_scroll_position = ny
		self.update_window()

	def WM_SIZE (self, wparam, lparam):
		self.size = winwin.SPLIT_WORD (lparam)
		w, h = self.size
		lh = self.line_height
		q,r = divmod (h,lh)
		self.scroll_model.page = q

def test (face, height):
	font = winfont.font (face, height=height).create()

	if not font:
		print "Couldn't create font %s:%d" % face, height
	else:
		import layout
		frame = layout.border_container (
			'Font Viewer: face=%s, height=%d' % (face, height),
			h=500,w=200
			).create()

		vm = mvc_scrollbar.scroll_model()
		vm.limit = 256
		vs = mvc_scrollbar.vertical_scrollbar_component (model=vm, parent=frame).create()

		w = font_viewer (
			parent = frame,
			style= winwin.WS_CHILD | winwin.WS_VISIBLE
			).create()
		w.font = font
		w.number_font = winfont.font ('Courier New', height=height).create()
		w.line_height = height
		# trivial sequence model (not used!)
		w.set_model (mvc.sequence_model (range(256)))
		w.scroll_model = vm
		vm.add_view (w)
		#w.show_window()

		frame.add (vs, 'east')
		frame.add (w,  'center')
		
		vm.add_view (w)

		return frame


if __name__ == '__main__':
	import sys

	if len(sys.argv) != 3:
		print 'Usage: %s <font-face-name> <font-height>' % sys.argv[0]
	else:
		import msgloop
		import string
		w = test (sys.argv[1], string.atoi (sys.argv[2]))
		w.show_window()
		msgloop.go()
