# -*- Mode: Python; tab-width: 4 -*-

# test the interaction of WaitForMultipleObjects
# and select().

# Goal: A single, integrated network and GUI event loop.
#
# Desire: Perhaps passing socket handles to WaitForMultipleObjects
# will let us know when _any_ of the sockets are ready.
#
# Result: Doesn't work.  Not sure if using winsock2 would make
# any difference.  Most likely the only way to do this is to
# completely re-implement something like select(), in terms of
# Winsock2's WSASend, WSARecv, etc...

import asyncore
import npstruct
import windll

kernel32 = windll.module ('kernel32')

def wait (sockets):
	
	print sockets
	n = len(sockets)
	handles = tuple (map (lambda x: x.fileno(), sockets))
	b = windll.membuf (npstruct.pack ('l'*n, handles))

	print 'waiting on %d handles' % n
	return kernel32.WaitForMultipleObjects (n, b, 0, 30000)


# wrapper around asyncore's loop
def loop ():
	while asyncore.socket_map:
		print 'wait=', wait (asyncore.socket_map.keys())
		asyncore.poll()

if __name__ == '__main__':
	import redirect
	import string
	import sys
	s = redirect.redirecting_server (
		string.atoi (sys.argv[1]),
		string.atoi (sys.argv[2])
		)
	loop()


