# -*- Mode: Python; tab-width: 4 -*-

import windc
import wingdi
import winwin
import layout
import mvc_scrollbar

# A replacement for 'winscroll' using our own scrollbar implementation.

# we embed the user-visible window in a frame, using border_layout to
# place scrollbars appropriately.
#

# TODO:
#
# Disappearing scrollbars (when page size is 100%)
#
# A 'zoom'-style control would probably want to use
# a model that combines two scroll models.  This would let
# the user move things diagonally, generating only a single
# update notification, and more efficient scrolling in certain
# types of windows.
#

SPLIT_WORD = winwin.SPLIT_WORD

class scroll_window (winwin.python_window):

	style=winwin.WS_CHILD | winwin.WS_VISIBLE

	last_scroll_position = 0, 0
	scroll_models = None, None

	def create (*args):
		self = apply (winwin.python_window.create, args)

		vm, hm = self.scroll_models
		if vm is None:
			vm = mvc_scrollbar.scroll_model()
			vm.add_view (self)
		if hm is None:
			hm = mvc_scrollbar.scroll_model()
			hm.add_view (self)
		
		self.scroll_models = vm, hm

		return self

	def begin_paint (self, paintstruct=None):
		dc = winwin.python_window.begin_paint (self, paintstruct)
		self.prepare_dc (dc)
		return dc

	def prepare_dc (self, dc):
		vm, hm = self.scroll_models
		dc.set_window_org (hm.position, vm.position)

	def get_dc (self):
		vm, hm = self.scroll_models
		dc = winwin.python_window.get_dc (self)
		dc.set_window_org (hm.position, vm.position)
		return dc

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		w, h = self.size
		vm, hm = self.scroll_models
		vm.page = h
		hm.page = w

	def notify (self, model, hint):
		vm, hm = self.scroll_models
		lx, ly = self.last_scroll_position
		nx, ny = hm.position, vm.position
		if model is vm:
			dx, dy = 0, ly - ny
		elif model is hm:
			dx, dy = lx - nx, 0

		self.scroll_window (dx, dy)
		self.last_scroll_position = nx, ny
		self.update_window()

import quadtree
import random

class box:
	def __init__ (self, rect, up=1):
		self.rect = rect
		self.up = up

	def get_rect (self):
		return self.rect

	def do_paint (self, dc):
		dc.draw_3d_box (self.rect, self.up)

	def __repr__ (self):
		return '<box at %s>' % repr(self.rect)

class quadtree_test (scroll_window):

	def populate (self, nrects=100, ww=2000):
		qt = quadtree.quadtree ((0, 0, ww, ww))
		for i in range (nrects):
			w = random.randint (10, 100)
			h = random.randint (10, 100)
			x = random.randint (0, ww)
			y = random.randint (0, ww)
			if x + w > ww:
				x = x - w
			if y + h > ww:
				y = y - h
			
			qt.insert (box ((x, y, x+w, y+h), random.randint (0,1)))

		self.quadtree = qt

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()

		clip = dc.get_clip_box()
		self.quadtree.search_apply (
			clip,
			lambda ob,dc=dc: ob.do_paint (dc)
			)
		self.end_paint()

	def WM_LBUTTONDOWN (self, wparam, lparam):
		def print_thing (thing):
			print thing

		# print those objects under the mouse
		dc = self.get_dc()
		x, y = dc.dp_to_lp (SPLIT_WORD (lparam))
		dc.release_dc()

		print '---'

		self.quadtree.search_apply (
			(x,y,x+1,y+1),
			print_thing
			)

def test():
	hm = mvc_scrollbar.scroll_model()
	vm = mvc_scrollbar.scroll_model()
	frame = layout.border_container('scroll test').create()
	qw = quadtree_test ('test', parent=frame, scroll_models = (vm, hm)).create()
	print 'calculating random rectangles...',
	qw.populate (3000, 10000)
	print 'done.'
	vs = mvc_scrollbar.vertical_scrollbar_component (model=vm, parent=frame).create()
	hs = mvc_scrollbar.horizontal_scrollbar_component (model=hm, parent=frame).create()

	frame.add (vs, 'east')
	frame.add (hs, 'south')
	frame.add (qw, 'center')

	l,t,r,b = qw.quadtree.get_bounds()
	hm.limit = r
	vm.limit = b
	hm.add_view (qw)
	vm.add_view (qw)

	for x in qw,vs,hs,frame:
		x.show_window()

	return frame

if __name__ == '__main__':
	import msgloop
	test()
	msgloop.go()
