# -*- Mode: Python; tab-width: 4 -*-
#	$Id: gencb.py,v 1.3 1996/05/27 05:52:40 rushing Exp $
#	Author: Sam Rushing <rushing@nightmare.com>

# Currently, we only generate i386 instructions

# We want to generate a callback function.  All callbacks are of the
# CALLBACK type (which means they use the 'stdcall' calling convention
# - the called function pops the arguments off the stack).

# ***
# We currently do NOT handle return values larger than 32 bits.
# They are returned in a register pair (EDX:EAX).  Wouldn't be _too_
# hard to do, but would require different assembly in call_ff_really.
# ***

# arguments are always widened to 32 bits.

# the callback needs to do the following:
# 1) get arguments [we pop them]
# 2) build a python argument tuple
# 3) call PyEval_CallObject()
# 4) return result [usually none]

# the information we need to do this is
# the address of the Python callback function object [can/should
#   we use the builtin id() function?]
# the number of arguments passed in
# the address of Py_BuildValue
# the type of those arguments [for the call to Py_BuildValue]
# the address of PyEval_CallObject [and its calling convention,
#   __cdecl probably, which means we will clean up after it?]

# What I'm doing here is getting the C compiler to tell me how
# it would compile a mockup of the callback procedure I want.
# By using casts and constant values for procedure and data addresses,
# I can simulate the situation where all these values are known.
# 
# long __stdcall
# mockup (long arg1, long arg2, long arg3)
# {
#   return
# 	// PyInt_AsLong
# 	((long (*) (PyObject *))0x44332211)
# 	(// PyEval_CallObject (function, args_tuple)
# 	 ((PyObject * (*) (PyObject *, PyObject *))0x33334444)
# 	 (((PyObject *)0x12345678),
# 	  // Py_BuildValue ('lll', arg1, arg2, arg3)
# 	  ((PyObject * (* __cdecl) (char *, ...))0x11112222) (0x43218765, arg1, arg2, arg3))
# 	 );
# }
# 
#   000000D7: 55                 push        ebp
#   000000D8: 8B EC              mov         ebp,esp
#   000000DA: 53                 push        ebx
#   000000DB: 56                 push        esi
#   000000DC: 57                 push        edi
#   000000DD: 8B 45 10           mov         eax,dword ptr [ebp+10h]
#   000000E0: 50                 push        eax
#   000000E1: 8B 45 0C           mov         eax,dword ptr [ebp+0Ch]
#   000000E4: 50                 push        eax
#   000000E5: 8B 45 08           mov         eax,dword ptr [ebp+8]
#   000000E8: 50                 push        eax
#   000000E9: 68 65 87 21 43     push        43218765h
#   000000EE: B8 22 22 11 11     mov         eax,11112222h
#   000000F3: FF D0              call        eax
#   000000F5: 83 C4 10           add         esp,10h
#   000000F8: 50                 push        eax
#   000000F9: 68 78 56 34 12     push        12345678h
#   000000FE: B8 44 44 33 33     mov         eax,33334444h
#   00000103: FF D0              call        eax
#   00000105: 83 C4 08           add         esp,8
#   00000108: 50                 push        eax
#   00000109: B8 11 22 33 44     mov         eax,44332211h
#   0000010E: FF D0              call        eax
#   00000110: 83 C4 04           add         esp,4
#   00000113: E9 00 00 00 00     jmp         00000118
#   00000118: 5F                 pop         edi
#   00000119: 5E                 pop         esi
#   0000011A: 5B                 pop         ebx
#   0000011B: C9                 leave
#   0000011C: C2 0C 00           ret         0Ch


# And here it is with 4 args:
# 
#   000000D7: 55                 push        ebp
#   000000D8: 8B EC              mov         ebp,esp
#   000000DA: 53                 push        ebx
#   000000DB: 56                 push        esi
#   000000DC: 57                 push        edi
#   000000DD: 8B 45 14           mov         eax,dword ptr [ebp+14h]
#   000000E0: 50                 push        eax
#   000000E1: 8B 45 10           mov         eax,dword ptr [ebp+10h]
#   000000E4: 50                 push        eax
#   000000E5: 8B 45 0C           mov         eax,dword ptr [ebp+0Ch]
#   000000E8: 50                 push        eax
#   000000E9: 8B 45 08           mov         eax,dword ptr [ebp+8]
#   000000EC: 50                 push        eax
#   000000ED: 68 65 87 21 43     push        43218765h
#   000000F2: B8 22 22 11 11     mov         eax,11112222h
#   000000F7: FF D0              call        eax
#   000000F9: 83 C4 14           add         esp,14h
#   000000FC: 50                 push        eax
#   000000FD: 68 78 56 34 12     push        12345678h
#   00000102: B8 44 44 33 33     mov         eax,33334444h
#   00000107: FF D0              call        eax
#   00000109: 83 C4 08           add         esp,8
#   0000010C: 50                 push        eax
#   0000010D: B8 11 22 33 44     mov         eax,44332211h
#   00000112: FF D0              call        eax
#   00000114: 83 C4 04           add         esp,4
#   00000117: E9 00 00 00 00     jmp         0000011C
#   0000011C: 5F                 pop         edi
#   0000011D: 5E                 pop         esi
#   0000011E: 5B                 pop         ebx
#   0000011F: C9                 leave
#   00000120: C2 10 00           ret         10h

# symbolically:
# 55                 push        ebp
# 8B EC              mov         ebp,esp
# 53                 push        ebx
# 56                 push        esi
# 57                 push        edi
# 8B 45 14           mov         eax,dword ptr [ebp+14h] # arg <n>
# 50                 push        eax
# 8B 45 10           mov         eax,dword ptr [ebp+10h] # arg <n-1>
# 50                 push        eax
# 8B 45 0C           mov         eax,dword ptr [ebp+0Ch] # arg <n-i>
# 50                 push        eax
# 8B 45 08           mov         eax,dword ptr [ebp+8]   # arg <1>
# 50                 push        eax
# 68 65 87 21 43     push        <format string for Py_BuildValue>
# B8 22 22 11 11     mov         eax, <Py_BuildValue>
# FF D0              call        eax
# 83 C4 14           add         esp,14h
# 50                 push        eax
# 68 78 56 34 12     push        <address of python function object>
# B8 44 44 33 33     mov         eax, <PyEval_CallObject>
# FF D0              call        eax
# 83 C4 08           add         esp,8
# 50                 push        eax
# B8 11 22 33 44     mov         eax, <PyInt_AsLong>
# FF D0              call        eax
# 83 C4 04           add         esp,4
# E9 00 00 00 00     jmp         0000011C
# 5F                 pop         edi
# 5E                 pop         esi
# 5B                 pop         ebx
# C9                 leave
# C2 10 00           ret         10h

# 0x12345678 => 0x78 0x56 0x34 0x12
def little_encode_long (x):
	return [(x		&0xff),
			(x>>8	&0xff),
			(x>>16	&0xff),
			(x>>24	&0xff)
			]

def little_encode_word (x):
	return [(x		&0xff),
			(x>>8	&0xff)]

import calldll

# these addresses are stored away for us by the calldll module's init function.
Py_BuildValue, PyInt_AsLong, PyEval_CallObject = calldll.addrs

# most of the decimal zeros below (save for the JMP parameter)
# are to be filled in with addresses at run-time.

template_prologue = [
	0x55,				# push		ebp
	0x8b,0xec,			# mov		ebp, esp
	0x53,				# push		ebx
	0x56,				# push		esi
	0x57,				# push		edi
	]

# one of these will be added for each argument
template_arg_push = [
	0x8b,0x45,00,		# mov		eax, dword ptr [ebp+XX] (XX == (arg number * 4) + 8) (offset 2)
	0x50				# push		eax
	]

template_rest = [
	0x68,00,00,00,00,	# push		<address of format string>		(offset 1)
	0xb8,00,00,00,00,	# mov		eax, <address of Py_BuildValue>	(offset 6)
	0xff,0xd0,			# call		eax
	0x83,0xc4,00,		# add		esp, XX (XX == (number of args * 4) + 4)	(offset 14)
	0x50,				# push		eax
	0x68,00,00,00,00,	# push		<address of python function object>	(offset 17)
	0xb8,00,00,00,00,	# mov		eax, <address of PyEval_CallObject>	(offset 22)
	0xff,0xd0,			# call		eax
	0x83,0xc4,0x08,		# add		esp, 8
	0x50,				# push		eax
	0xb8,00,00,00,00,	# move		eax, <address of PyInt_AsLong>	(offset 33)
	0xff,0xd0,			# call		eax
	0x83,0xc4,0x04,		# add		esp, 4
	0xe9,00,00,00,00,	# jmp		<to the next instruction>
	]

template_epilogue = [
	0x5f,				# pop		edi
	0x5e,				# pop		esi
	0x5b,				# pop		ebx
	0xc9,				# leave
	0xc2,00,00,			# ret		XX (XX == num_args * 4), word	(offset 5)
	]


def string_to_membuf (s):
	mb = calldll.membuf (len(s))
	mb.write (s)
	return mb

def gen_callback (arg_format_string, python_function, thread_lock=0):
	num_args = len(arg_format_string)
	# tupleize it, ZERO-TERMINATE IT(!), to make Py_BuildValue happy.
	arg_format_string = '(%s)\000' % arg_format_string
	# copy the arg string into a membuf object, so we
	# don't have to do BAD things like poking into string
	# objects.
	arg_membuf = string_to_membuf (arg_format_string)
	python_function_object_address = id(python_function)
	r = template_prologue

	for i in range(num_args):
		ap = template_arg_push[:]
		ap[2] = ((num_args-i) * 4)+4
		r = r + ap

	tr = template_rest[:]
	tr[1:5]		= little_encode_long (arg_membuf.address())
	tr[6:10]	= little_encode_long (Py_BuildValue)
	tr[14]		= (num_args * 4)+4
	tr[17:21]	= little_encode_long (python_function_object_address)
	tr[22:26]	= little_encode_long (PyEval_CallObject)
	tr[33:37]	= little_encode_long (PyInt_AsLong)
	r = r + tr

	te = template_epilogue[:]
	te[5:7]		= little_encode_word (num_args * 4)
	r = r + te
	# important to not let <mb> die!
	return arg_membuf, r

import string
class generated_callback:
	def __init__ (self, arg_format_string, python_function, thread_lock=0):
		self.arg_mb, bytes = gen_callback (arg_format_string, python_function, thread_lock)
		# important to save a reference to this
		self.function_object = python_function
		bytes = map (chr, bytes)
		bytes = string.joinfields (bytes, '')
		self.cb_mb = string_to_membuf (bytes)
		self.address = self.cb_mb.address()

	def __int__ (self):
		return self.address

cb_cache = {}
def callback (arg_format_string, python_function):
	# check the cache first
	if cb_cache.has_key (python_function, arg_format_string):
		return cb_cache[(python_function, arg_format_string)]
	else:
		cb = generated_callback (arg_format_string, python_function)
		cb_cache[(python_function, arg_format_string)] = cb
		return cb
