# -*- Mode: Python; tab-width: 4 -*-

# This is specific to Microsoft C++'s C Runtime Library.

import gencb
import structob
import windll

crt = windll.module ('msvcrt')

# typedef struct _heapinfo {
#         int * _pentry;
#         size_t _size;
#         int _useflag;
#         } _HEAPINFO;

_HEAPEMPTY      = (-1)
_HEAPOK         = (-2)
_HEAPBADBEGIN   = (-3)
_HEAPBADNODE    = (-4)
_HEAPEND        = (-5)
_HEAPBADPTR     = (-6)
_FREEENTRY      = 0
_USEDENTRY      = 1

from structob import struct_object, Oracle

class heapinfo (struct_object):
	oracle = Oracle (
		'heapinfo',
		'Nlll',
		('entry', 'size', 'useflag',),
		)

def walk_heap ():
	print 'walk heap'
	hi = heapinfo()
	
	total_used = 0
	total_free = 0
	while 1:
		heapstatus = crt._heapwalk (hi)
		if heapstatus != _HEAPOK:
			break
		else:
			if hi.useflag == _USEDENTRY:
				state = 'used'
				total_used = total_used + hi.size
			else:
				state = 'free'
				total_free = total_free + hi.size
			print '%s block at %08x of size %08x' % (
				state,
				hi.entry,
				hi.size
				)
				
	if heapstatus ==  _HEAPEMPTY:
		print 'OK - empty heap'
	elif heapstatus ==  _HEAPEND:
		print 'OK - end of heap'
	elif heapstatus ==  _HEAPBADPTR:
		print 'ERROR - bad pointer to heap'
	elif heapstatus ==  _HEAPBADBEGIN:
		print 'ERROR - bad start of heap'
	elif heapstatus ==  _HEAPBADNODE:
		print 'ERROR - bad node in heap'

	print 'Total Used: %08x' % total_used
	print 'Total Free: %08x' % total_free
