# -*- Mode: Python; tab-width: 4 -*-

# Fresco/TeX-style layout.
#
# This would be a major step toward 'flyweight' objects.  We would be
# able to do layout without waisting container windows, but we might
# also be able to have components that are not real windows.
#
#    +-------------- hbox -----------------+
#    |+-vbox--+                 +---------+|
#    ||+-----+|                 |         ||
#    |||     ||+---------------+|         ||
#    ||+-----+||               ||         ||
#    ||+-----+||               ||         ||
#    |||     ||+---------------+|         ||
#    ||+-----+|                 +---------+|
#    |+-------+                            |
#    +------------------- -----------------+
#
# ===========================================================================
# [from the fresco manual]
#
# o An hbox tiles its children left-to-right along the X axis and
#   aligns their origins along the Y axis.
#
# o A vbox tiles its children top-to-bottom along the Y axis and
#   aligns their origins along the X axis.
#
# o The natural, minimum, and maximum sizes along the tiling axis are
#   the sums of the child natural, minimum, and maximum sizes,
#   respectively.
#
# o The natural size along the alignment axis is the maximum of the
#   child natural sizes.
#   
# o The minimum size along the alignment axis is the maximum of the
#   child minimum sizes.
#   
# o The maximum size along the alignment axis is the mnimum of the
#   child maximum sizes.

# ===========================================================================
# Each component thus has six numbers associated with it:
#
#    ((min_x, nat_x, max_x), (min_y, nat_y, max_y))
#

# For the moment, we will dispense with the idea of 'minimum' sizes.

import sys

def sum (l):
	sum = 0
	for n in l:
		if n == sys.maxint:
			return sys.maxint
		else:
			sum = sum + n
	return sum

def select (a,b):
	# cure for the clumsy lambda
	return (lambda x,a=a,b=b: x[a][b])

layout_error = "Layout Error"

class box:

	HORZ = 0
	VERT = 1

	def __init__ (self, axis):
		self.children = []
		self.tiling_axis = axis

	def append (self, child):
		self.children.append (child)

	def remove (self, child):
		self.children.remove (child)

	def get_layout_sizes (self):
		sizes = map (lambda x: x.get_layout_sizes(), self.children)
		t = self.tiling_axis
		# tiling axis
		ta_sizes = (
			# natural
			sum (map (select (1,t), sizes)),			
			# maximum
			sum (map (select (2,t), sizes))
			)
		# alignment axis
		t = not t
		aa_sizes = (
			# natural
			max (map (select (1,t), sizes)),			
			# maximum
			min (map (select (2,t), sizes))
			)
		return ta_sizes, aa_sizes

	def do_layout (self, rect):
		l,t,r,b = rect
		w, h = r-l, b-t
		sizes = map (lambda x: x.get_layout_sizes(), self.children)
		# positions along the tiling axis
		ta_pos = []
		t = self.tiling_axis
		n_sizes = map (select (0, t), sizes)
		m_sizes = map (select (1, t), sizes)
		# get the sum of non-maxint natural sizes

			
class hbox (box):
	
	def __init__ (self):
		return box.__init__ (self, box.HORZ)

class vbox (box):
	
	def __init__ (self):
		return box.__init__ (self, box.VERT)

class thing:
	def __init__ (self, sizes):
		self.sizes = sizes

	def get_layout_sizes (self):
		return self.sizes


