# -*- Mode: Python; tab-width: 4 -*-

import npstruct

#from dyn_win32 import structob, winwin, windll
import structob
import winwin
import windll

LVIF_TEXT               = 0x0001
LVIF_IMAGE              = 0x0002
LVIF_PARAM              = 0x0004
LVIF_STATE              = 0x0008
LVIF_INDENT             = 0x0010
LVIF_NORECOMPUTE        = 0x0800

LVIS_FOCUSED            = 0x0001
LVIS_SELECTED           = 0x0002
LVIS_CUT                = 0x0004
LVIS_DROPHILITED        = 0x0008

LVIS_OVERLAYMASK        = 0x0F00
LVIS_STATEIMAGEMASK     = 0xF000

# typedef struct _LV_ITEM {  
#     UINT   mask; 
#     int    iItem; 
#     int    iSubItem; 
#     UINT   state; 
#     UINT   stateMask; 
#     LPTSTR  pszText; 
#     int    cchTextMax; 
#     int    iImage;       // index of the list view item's icon 
#     LPARAM lParam;       // 32-bit value to associate with item 
# } LV_ITEM; 

class LV_ITEM (structob.struct_object):
	oracle = structob.Oracle (
		'listview item',
		'Nlllllllll',
		('mask',
		 'item',
		 'sub_item',
		 'state',
		 'state_mask',
		 'text',
		 'text_max',
		 'image',
		 'lparam'
		 )
		)
		
LVCF_FMT                = 0x0001
LVCF_WIDTH              = 0x0002
LVCF_TEXT               = 0x0004
LVCF_SUBITEM            = 0x0008
LVCF_IMAGE              = 0x0010
LVCF_ORDER              = 0x0020

LVCFMT_LEFT             = 0x0000
LVCFMT_RIGHT            = 0x0001
LVCFMT_CENTER           = 0x0002
LVCFMT_JUSTIFYMASK      = 0x0003
LVCFMT_IMAGE            = 0x0800
LVCFMT_BITMAP_ON_RIGHT  = 0x1000
LVCFMT_COL_HAS_IMAGES   = 0x8000

# typedef struct _LV_COLUMN {  
#     UINT mask; 
#     int fmt; 
#     int cx; 
#     LPTSTR pszText; 
#     int cchTextMax; 
#     int iSubItem; 
# } LV_COLUMN; 

class LV_COLUMN (structob.struct_object):
	oracle = structob.Oracle (
		'listview column',
		'Nllllll',
		('mask',
		 'fmt',
		 'x',
		 'text',
		 'text_max',
		 'sub_item'
		 )
		)

LVS_ICON                = 0x0000
LVS_REPORT              = 0x0001
LVS_SMALLICON           = 0x0002
LVS_LIST                = 0x0003
LVS_TYPEMASK            = 0x0003
LVS_SINGLESEL           = 0x0004
LVS_SHOWSELALWAYS       = 0x0008
LVS_SORTASCENDING       = 0x0010
LVS_SORTDESCENDING      = 0x0020
LVS_SHAREIMAGELISTS     = 0x0040
LVS_NOLABELWRAP         = 0x0080
LVS_AUTOARRANGE         = 0x0100
LVS_EDITLABELS          = 0x0200
LVS_OWNERDATA           = 0x1000
LVS_NOSCROLL            = 0x2000

LVS_TYPESTYLEMASK       = 0xfc00

LVS_ALIGNTOP            = 0x0000
LVS_ALIGNLEFT           = 0x0800
LVS_ALIGNMASK           = 0x0c00

LVS_OWNERDRAWFIXED      = 0x0400
LVS_NOCOLUMNHEADER      = 0x4000
LVS_NOSORTHEADER        = 0x8000


LVM_DELETEALLITEMS		= 4105
LVM_INSERTCOLUMN		= 4123
LVM_GETITEM				= 4101
LVM_SETITEM				= 4102
LVM_INSERTITEM			= 4103



cstring = windll.cstring

# initialize common controls library
comctl32 = windll.module ('comctl32')
comctl32.InitCommonControls()

class list_view (winwin.subclassed_window):

	def insert_column (self, index, text, fmt=None, sub_item=None, width=None, **keyargs):
		col = LV_COLUMN()
		col.mask = LVCF_TEXT
		text = cstring (text)
		col.text = text.address()
		col.text_max = len(text)

		if fmt is not None:
			col.mask = col.mask | LVCF_FMT
			col.fmt = fmt

		if width is not None:
			col.mask = col.mask | LVCF_WIDTH
			col.x = width
			
		if sub_item is not None:
			col.mask = col.mask | LVCF_SUBITEM
			col.sub_item = sub_item

		col._set_values (keyargs)
		return self.send_message (LVM_INSERTCOLUMN, index, col)

	def insert_item (self,
					 text,
					 image=None,
					 param=None,
					 state=None,
					 **keyargs):
		item = LV_ITEM()
		text = cstring (text)
		item.mask = LVIF_TEXT
		item.text = text.address()
		item.text_max = len(text)
		
		if image is not None:
			item.mask = item.mask | LVIF_IMAGE
			item.image = image
		if param is not None:
			item.mask = item.mask | LVIF_PARAM
			item.lparam = param
		if state is not None:
			item.mask = item.mask | LVIF_STATE
			item.state = state
		item._set_values (keyargs)
		return self.send_message (LVM_INSERTITEM, 0, item)
			
	def set_item (self,
					 text,
					 image=None,
					 param=None,
					 state=None,
					 **keyargs):
		item = LV_ITEM()
		text = cstring (text)
		item.mask = LVIF_TEXT
		item.text = text.address()
		item.text_max = len(text)
		
		if image is not None:
			item.mask = item.mask | LVIF_IMAGE
			item.image = image
		if param is not None:
			item.mask = item.mask | LVIF_PARAM
			item.lparam = param
		if state is not None:
			item.mask = item.mask | LVIF_STATE
			item.state = state
		item._set_values (keyargs)
		return self.send_message (LVM_SETITEM, 0, item)

	def WM_DESTROY (self, wparam, lparam):
		print 'destroying...'
		winwin.user32.PostQuitMessage (0)

def test (name='a window'):

	test_list = [
		('Sam', 'Hi!'),
		('Jim', 'Hey...'),
		('Joe', 'Microsoft Buys GM')
		]
	
	p = list_view (name, 'SysListView32', style=winwin.WS_OVERLAPPEDWINDOW | LVS_REPORT)
	p.create()
	print 'before show window', p.original_wndproc
	p.show_window()
	print 'after show window'
	p.insert_column (1, 'From', width=100)
	p.insert_column (2, 'Subject', width=100)

	for i in range(len(test_list)):
		f, s = test_list[i]
		print p.insert_item (f, item=i, sub_item=0)
		print p.set_item (s, item=i, sub_item=1)

	return p

if __name__ == '__main__':
	import dyn_win32.msgloop
	print 'after'
	t = test()
	print 'msgloop...'
	dyn_win32.msgloop.go()
