# -*- Mode: Python; tab-width: 4 -*-

import windc
import winfont
import wingdi
import winwin
import string

SPLIT_WORD = winwin.SPLIT_WORD

class item:
	menu_color		= windc.get_sys_color (windc.COLOR_MENU)
	menu_brush		= windc.get_sys_brush (windc.COLOR_MENU)
	menu_pen		= windc.get_sys_pen   (windc.COLOR_MENU)
	text_color		= windc.get_sys_color (windc.COLOR_MENUTEXT)
	hl_text_color	= windc.get_sys_color (windc.COLOR_HIGHLIGHTTEXT)
	hl_color		= windc.get_sys_color (windc.COLOR_3DHILIGHT)
	shadow_color	= windc.get_sys_color (windc.COLOR_3DSHADOW)
	shadow_pen		= windc.get_sys_pen   (windc.COLOR_3DSHADOW)
	shadow_brush	= windc.get_sys_brush (windc.COLOR_3DSHADOW)
	hl_pen			= windc.get_sys_pen   (windc.COLOR_3DHILIGHT)

class text_item (item):

	def __init__ (self, text, state=1, callback=None):
		self.text = text
		self.state = state
		self.callback = callback

	def draw (self, dc, y, w, mh, mw, highlight):
		# base offset
		bmh = (mh - self.font_height)/2

		if not highlight:
			dc.select_object (self.menu_pen)
			dc.select_object (self.menu_brush)					
			dc.rectangle ((4,y-mh+bmh,w-4,y+bmh))
		if state:
			if highlight:
				dc.select_object (self.shadow_brush)
				dc.select_object (self.shadow_pen)
				dc.rectangle ((4,y-mh+bmh,w-4,y+bmh))
				dc.set_text_color (self.hl_text_color)
			else:
				dc.set_text_color (self.text_color)
			dc.text_out ((mw, y), text)
		else:
			dc.set_text_color (self.hl_color)
			dc.text_out ((mw+1, y+1), text)
			dc.set_text_color (self.shadow_color)
			dc.text_out ((mw, y), text)

class separator_item (item):

	def draw (self, dc, y, w, mh, mw, highlight):
		# base offset
		bmh = (mh - self.font_height)/2
		my = y-(mh/2)
		dc.select_object (self.shadow_pen)
		dc.move_to ((4, my))
		dc.line_to ((w-4, my))
		dc.select_object (self.hl_pen)
		dc.move_to ((4, my+1))
		dc.line_to ((w-4, my+1))

class menu (winwin.python_window):
	
	non_client_metrics = winfont.get_non_client_metrics()
	font = winfont.get_system_fonts(non_client_metrics)['menu_font'].create()
	font_height = abs (font.lf.height)
	menu_height = non_client_metrics.menu_height
	menu_width  = non_client_metrics.menu_width

	TEXT		= 1
	SEPARATOR	= 2

	style = winwin.WS_POPUP
	x, y = 100, 100
	w, h = 200, 400

	menu_color		= windc.get_sys_color (windc.COLOR_MENU)
	menu_brush		= windc.get_sys_brush (windc.COLOR_MENU)
	menu_pen		= windc.get_sys_pen   (windc.COLOR_MENU)
	text_color		= windc.get_sys_color (windc.COLOR_MENUTEXT)
	hl_text_color	= windc.get_sys_color (windc.COLOR_HIGHLIGHTTEXT)
	hl_color		= windc.get_sys_color (windc.COLOR_3DHILIGHT)
	shadow_color	= windc.get_sys_color (windc.COLOR_3DSHADOW)
	shadow_pen		= windc.get_sys_pen   (windc.COLOR_3DSHADOW)
	shadow_brush	= windc.get_sys_brush (windc.COLOR_3DSHADOW)
	hl_pen			= windc.get_sys_pen   (windc.COLOR_3DHILIGHT)

	def create (*args):
		args[0].style = winwin.WS_POPUP | winwin.WS_VISIBLE
		return winwin.python_window.create (args[0])

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		self.draw_menu (dc)
		self.end_paint()

	hl_line = None

	def WM_MOUSEMOVE (self, wparam, lparam):
		x, y =  SPLIT_WORD (lparam)
			
		index = y / self.menu_height
		dc = self.get_dc()
		self.prepare_dc (dc)

		if index < len(self.items):
			if self.hl_line != index:
				if self.hl_line is not None:
					self.draw_line (dc, self.hl_line, 0)
				self.draw_line (dc, index, 1)
				self.hl_line = index
		else:
			if self.hl_line is not None:
				self.draw_line (dc, self.hl_line, 0)
			self.hl_line = None

		dc.release_dc()

	def prepare_dc (self, dc):
		dc.select_object (self.font)
		dc.set_bk_color()
		dc.set_bk_mode (windc.TRANSPARENT)
		dc.set_text_align (wingdi.TA_BOTTOM)

	def draw_line (self, dc, index, highlight=0):
		mw = self.menu_width
		dy = self.menu_height
		l,t,r,b = self.get_client_rect()
		w, h = r-l, b-t
		y = (index+1) * dy
		# base offset
		bdy = (dy - self.font_height)/2

		kind, state, text, object = self.items[index]

		if kind == self.TEXT:
			if not highlight:
				dc.select_object (self.menu_pen)
				dc.select_object (self.menu_brush)					
				dc.rectangle ((4,y-dy+bdy,w-4,y+bdy))
			if state:
				if highlight:
					dc.select_object (self.shadow_brush)
					dc.select_object (self.shadow_pen)
					dc.rectangle ((4,y-dy+bdy,w-4,y+bdy))
					dc.set_text_color (self.hl_text_color)
				else:
					dc.set_text_color (self.text_color)
				dc.text_out ((mw, y), text)
			else:
				dc.set_text_color (self.hl_color)
				dc.text_out ((mw+1, y+1), text)
				dc.set_text_color (self.shadow_color)
				dc.text_out ((mw, y), text)
		elif kind == self.SEPARATOR:
			my = y-(dy/2)
			dc.select_object (self.shadow_pen)
			dc.move_to ((4, my))
			dc.line_to ((w-4, my))
			dc.select_object (self.hl_pen)
			dc.move_to ((4, my+1))
			dc.line_to ((w-4, my+1))
		else:
			raise ValueError, "Unknown Menu Item Type"

	def draw_menu (self, dc):

		if not self.font_height:
			self.font_height = dc.get_text_metrics().height

		self.prepare_dc (dc)
		dc.draw_3d_box (self.get_client_rect())

		for i in range (len (self.items)):
			self.draw_line (dc, i)

	items = [
		[TEXT,			1,	'Item One', None],
		[TEXT,			1,	'Item Two', None],
		[SEPARATOR, 	0,	None, None],		
		[TEXT,			1,	'Collapse Universe', None],
		[TEXT,			1,	'Whirled Peas', None],
		[SEPARATOR, 	0,	None, None],				
		[TEXT,			0,	'Disabled Item', None],
		[TEXT,			1,	'Enabled Item', None],
		[TEXT,			1,	'Crash Windows 95', None],
		]


def test():
	m = menu('test menu')
	m.create()
	m.show_window()
	return m
	
