# -*- Mode: Python; tab-width: 4 -*-

# from <winuser.h>
#
# WM_NCCALCSIZE "window valid rect" return values
#
WVR_ALIGNTOP        = 0x0010
WVR_ALIGNLEFT       = 0x0020
WVR_ALIGNBOTTOM     = 0x0040
WVR_ALIGNRIGHT      = 0x0080
WVR_HREDRAW         = 0x0100
WVR_VREDRAW         = 0x0200
WVR_REDRAW         = (WVR_HREDRAW | WVR_VREDRAW)
WVR_VALIDRECTS      = 0x0400

# typedef struct _NCCALCSIZE_PARAMS { // nccp  
#     RECT        rgrc[3]; 
#     PWINDOWPOS  lppos; 
# } NCCALCSIZE_PARAMS; 
 
import structob

# typedef struct _WINDOWPOS { // wp   
#     HWND hwnd;                     
#     HWND hwndInsertAfter;          
#     int  x;                        
#     int  y;                        
#     int  cx;                       
#     int  cy;                       
#     UINT flags;                    
# } WINDOWPOS; 
 
class WINDOWPOS (structob.struct_object):
	oracle = structob.Oracle (
		'window_position',
		'Nlllllll',
		('hwnd',
		 'hwnd_insert_after',
		 'x',
		 'y',
		 'cx',
		 'cy',
		 'flags'
		 )
		)
	
import wintypes
class NCCALCSIZE_PARAMS (structob.struct_object):
	oracle = structob.Oracle (
		'non_client_calc_size_params',
		'N[rect][rect][rect]l',
		('new_rect','old_rect', 'old_client_rect', 'pos'),
		rect = wintypes.t_rect.oracle
		)
	oracle.size = oracle.size + (3 * wintypes.t_rect.oracle.size)

import windc
import winwin
SPLIT_WORD = winwin.SPLIT_WORD

class non_client_mixin:

	once_only = 0

	# The documentation for WM_NCCALCSIZE is pretty lame.

	def WM_NCCALCSIZE (self, wparam, lparam):
		nccs = NCCALCSIZE_PARAMS (address=lparam)
		nwr = nccs.new_rect['rect']
		owr = nccs.old_rect['rect']
		ocr = nccs.old_client_rect['rect']
		margins = self.calculate_margins (owr, ocr)
		l,t,r,b = nwr
		self.margins = margins
		# tuck in some extra room...
		t = t + 20
		nwr = l,t,r,b
		nccs.new_rect = {'rect': nwr }
		# remember this...
		self.window_rect = nwr
		return 0

	def calculate_margins (self, window, client):
		wl,wt,wr,wb = window
		cl,ct,cr,cb = client
		return (cl - wl, ct - wt, wr - cr, wb - cb)

	def WM_NCPAINT (self, wparam, lparam):
		dc = self.get_window_dc()
		l,t,r,b = self.window_rect
		w = r-l
		ml,mt,mr,mb = self.margins

		menu_brush = windc.get_sys_brush (windc.COLOR_MENU)
		menu_pen   = windc.get_sys_pen   (windc.COLOR_MENU)
		dc.select_object (menu_brush)
		dc.select_object (menu_pen)
		dc.rectangle ((ml,mt-20,w,mt))

		dc.release_dc()
		return 0

	def WM_NCMOUSEMOVE (self, wparam, lparam):
		mx, my = SPLIT_WORD (lparam)
		print mx, my
	
