# -*- Mode: Python; tab-width: 4 -*-

# within its own window?

import windc
import winwin

SPLIT_WORD = winwin.SPLIT_WORD

class vertical_scrollbar (winwin.python_window):

	scroll_position = 25, 100
	page_size = 50, 100

	def set_scroll_ranges (self, ranges):
		self.ranges = ranges

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		self.do_paint (dc)
		self.end_paint()

	captured = None

	def WM_LBUTTONDOWN (self, wparam, lparam):
		x, y = SPLIT_WORD (lparam)
		u, l, b, t = self.get_rects()
		tl, tt, tr, tb = t
		# did they hit the thumb?
		if (y >= tt) and (y < tb):
			self.captured = y
			self.set_capture()
			
	def WM_MOUSEMOVE (self, wparam, lparam):
		if self.captured is not None:
			dc = self.get_dc()
			x, y = SPLIT_WORD (lparam)
			u, l, b, t = self.get_rects()
			dy = y - self.captured
			tl,tt,tr,tb = t
			if dy < 0:
				ul,ut,ur,ub = u
				# range test
				if (tt + dy) < ub:
					dy = ub - tt
				tt = tt + dy
				tb = tb + dy
				t = tl, tt, tr, tb
				self.rects = (u,l,b,t)
				# draw the thumb in its new position
				dc.draw_3d_box (t)
				# erase the area behind it
				dc.fill_rect (
					(tl,1+tb,tr,1+tb-dy),
					windc.get_sys_brush (windc.COLOR_WINDOW)
					)
				self.captured = y
			else:
				ll,lt,lr,lb = l
				# range test
				if (tb + dy) >= lt:
					dy = lt - tb - 1
				tt = tt + dy
				tb = tb + dy
				t = tl, tt, tr, tb
				self.rects = (u, l, b, t)
				dc.draw_3d_box (t)
				# erase the area behind it
				dc.fill_rect (
					(tl,tt-dy,tr,tt),
					windc.get_sys_brush (windc.COLOR_WINDOW)
					)
				self.captured = y
			
	def WM_LBUTTONUP (self, wparam, lparam):
		self.captured = None
		self.release_capture()

	rects = None

	def WM_SIZE (self, wparam, lparam):
		self.rects = None
		return 0
	
	def get_rects (self):
		if not self.rects:
			self.rects = self.calculate_rects()
		return self.rects

	def calculate_rects (self):
		l,t,r,b = self.get_client_rect()

		w = (r-l)
		upper = (l,t,r,t+w)
		lower = (l,b-w,r,b)
		back = (l, t+w, r, b-w)
		h = (b-w) - (t+w)
		# position
		n, d = self.scroll_position
		tp = (n * h) / d
		# page size
		n, d = self.page_size
		th = (n * h) / d
		if th > h:
			th = h
		if th < 10:
			th = 10
		ty = (t+w)+tp
		thumb = (l,ty,r,ty+th)
		return upper, lower, back, thumb

	def do_paint (self, dc):
		upper, lower, back, thumb = self.calculate_rects()
		dc.draw_3d_box (upper)
		dc.draw_3d_box (lower)
		dc.fill_rect (back, windc.get_sys_brush (windc.COLOR_WINDOW))
		dc.draw_3d_box (thumb)
		
def test ():
	vs = vertical_scrollbar ('vert', style=winwin.WS_POPUP)
	vs.w = 16
	vs.h = 640
	vs.create()
	vs.show_window()
	return vs

if __name__ == '__main__':
	import msgloop
	vs = test()
	msgloop.go()
