# -*- Mode: Python; tab-width: 4 -*-

import StringIO
import os
import string
import sys
import textedit
import pprint

class python_edit_window (textedit.text_edit_window):

	def draw_line (self, dc, y, index):
		dc.move_to ((0, y))
		line = self.lines[index]

		sline = string.strip (line)
		if sline and sline[0] == '#':
			dc.set_text_color ((128,0,0))
		else:
			dc.set_text_color ((0,0,0))

		dc.text_out ((0,0), line)
		px, py = dc.move_to_ex ((0,0))

		# this is an ugly but effective way to get the font width
		if not self.font_width:
			if px:
				self.font_width = px/len(line)
				self.show_caret()
	
std_files = None, None, None

class python_interpreter (textedit.text_edit_window):

	herald_color = (  0,   0, 192)
	input_color =  (  0,   0,   0)
	output_color = (  0, 128,   0)
	error_color =  (192,   0,   0)
	counter = 0

	def create (*args):
		apply (textedit.text_edit_window.create, args)
		self = args[0]
		python_interpreter.counter = python_interpreter.counter + 1
		self.set_window_text ('Python Interpreter %d' % self.counter)

	def make_herald (self):
		herald = (
			'Python DynWin Interpreter Copyright 1998 Nightmare Software',
			'Python %s on Win32' % (sys.version),
			sys.copyright,
			)
		result = []
		for line in herald:
			result.append (self.herald_color, line)
		return result

	def prompt (self):
		self.lines.append (self.input_color, '>>> ')
		n = len (self.lines)
		self.current_pos = (4, n-1)
		self.set_caret_pos()
		self.invalidate_line_range (n-1, n)
		self.scoot()
		self.set_virtual_window ((0, 0, self.widest_line, self.font_height * len(self.lines)))

	def scoot (self):
		"scroll the window up to make room for output"
		fh = self.font_height
		w, h = self.size
		n = len (self.lines)
		if (n*fh) > (self.y_pos + h):
			dy = (n*fh) - (self.y_pos + h)
			self.scroll_window (0, -dy)
			self.y_pos = self.y_pos + dy
			self.set_scroll_info()

	def WM_LBUTTONDOWN (self, wparam, lparam):
		return 0

	def WM_CHAR (self, wparam, lparam):
		# insert / overwrite, etc...
		lh = self.font_height
		ch = chr (wparam)
		w, h = self.size
		x, y = self.current_pos
		fw = self.font_width

		color, line = self.lines[y]

		if ch == '\r':
			# carriage return
			if line and line[:4] == '>>> ':
				self.handle_line_input (line[4:])
				self.line_history_index = 0
			else:
				self.prompt()

		elif ch == '\010':
			# backspace
			self.lines[y] = color, line[:-1]
			self.current_pos = x-1, y
			self.invalidate_rect (
				((x-2) * fw , y * lh, w, (y+1) * lh)
				)
		elif ch in ('\020', '\016'):
			# ctrl-p previous line, ctrl-n next line
			if ch == '\020':
				delta = +1
			else:
				delta = -1
			self.line_history_index = (self.line_history_index + delta) % len(self.line_history)
			line = self.line_history[-self.line_history_index]
			self.lines[y] = color, line
			self.current_pos = len(line), y
			self.invalidate_rect ((0, y*lh, w, (y+1)*lh))
		else:
			chars = map (None, line)
			chars.insert (x, ch)
			self.lines[y] = (
				self.input_color, string.join (chars, '')
				)
			x = x + 1
			self.current_pos = x, y
			self.invalidate_rect (
				((x-1) * fw , y * lh, w, (y+1) * lh)
				)

		self.set_caret_pos()

		return 1

	widest_line = 0

	def draw_line (self, dc, y, index):
		dc.move_to ((0, y))
		color, line = self.lines[index]

		dc.set_text_color (color)
		dc.text_out ((0,0), line)
		px, py = dc.move_to_ex ((0,0))

		# this is an ugly but effective way to get the font width
		if not self.font_width:
			if px:
				self.font_width = px/len(line)
				self.show_caret()

		if px > self.widest_line:
			# this isn't right.
			self.widest_line = px
			self.set_virtual_window ((0,0,self.widest_line, self.font_height * len (self.lines)))

	multi_line = 0

	local_env = {}

	line_history = None
	line_history_index = 0

	def handle_line_input (self, line):
		# check for special case inputs...
		if not line and not self.multi_line:
			self.prompt()
			return
		else:
			# manage line history
			hline = '>>> ' + line
			if self.line_history is None:
				self.line_history = []

			if self.line_history and self.line_history[-1] == hline:
				# don't fill the history with copies of a single line
				pass
			else:
				self.line_history.append (hline)
				
		global std_files
		std_files = sys.stdin, sys.stdout, sys.stderr
		try:
			of = StringIO.StringIO()
			ef = StringIO.StringIO()
			sys.stdout = of
			sys.stderr = ef
			try:
				try:
					# first try eval
					co = compile (line, repr(self), 'eval')
					result = eval (co, self.local_env)
					if result is not None:
						pprint.pprint (result)
					self.local_env['_'] = result
				except SyntaxError:
					# now try exec
					co = compile (line, repr(self), 'exec')
					exec co in self.local_env
			except:
				self.write_traceback (
					sys.exc_type,
					sys.exc_value,
					sys.exc_traceback,
					sys.stderr
					)
		finally:
			sys.stdin, sys.stdout, sys.stderr = std_files

		ef.seek (0)
		lines = ef.readlines()
		self.append_lines (lines, self.error_color)
		of.seek (0)
		lines = of.readlines()
		self.append_lines (lines, self.output_color)
		self.prompt()

	def append_lines (self, lines, color):
		on = len (self.lines)

		for line in lines:
			self.lines.append (color, self.frob_line (line))

		nn = len (self.lines)
		self.invalidate_line_range (on-2, nn)
		
	def frob_line (self, line):

		while line and line[-1] in '\r\n':
			line = line[:-1]

		return string.join (string.split (line, '\t'), '    ')


	def write_traceback (self, t, v, tb, file):
		tbinfo = []
		file.write ('Traceback (innermost last)\n')
		file.write ('%s: %s\n' % (t,v))
		r = repr(self)
		while 1:
			filename = tb.tb_frame.f_code.co_filename
			if filename == r:
				filename = "<stdin>"
			file.write (
				'  File "%s", line %d in %s\n' % (
					filename,
					tb.tb_lineno,
					tb.tb_frame.f_code.co_name
					)
				)
			tb = tb.tb_next
			if not tb:
				break


def new_window ():
	w = python_interpreter ('')
	w.lines = w.make_herald()
	w.create()
	w.show_window()
	w.prompt()
	return w

if __name__ == '__main__':

	new_window()
	import msgloop
	msgloop.go()
