# -*- Mode: Python; tab-width: 4 -*-

# I think we can load bitmaps like this:
# Get the BMP file into a memory buffer.
# Use CreateCompatibleBitmap, and then SetDIBits.
#

import windll
import win32file
import structob

gdi32 = windll.module ('gdi32')

# typedef struct tagBITMAPFILEHEADER { // bmfh  
#         WORD    bfType; 
#         DWORD   bfSize; 
#         WORD    bfReserved1; 
#         WORD    bfReserved2; 
#         DWORD   bfOffBits; 
# } BITMAPFILEHEADER; 

class BITMAPFILEHEADER (structob.struct_object):
	oracle = structob.Oracle (
		'bitmap_file_header',
		'Nhlhhl',
		('type','size', 'reserved1', 'reserved2', 'off_bits')
		)

# typedef struct tagBITMAPINFOHEADER{ // bmih  
#    DWORD  biSize; 
#    LONG   biWidth; 
#    LONG   biHeight; 
#    WORD   biPlanes; 
#    WORD   biBitCount 
#    DWORD  biCompression; 
#    DWORD  biSizeImage; 
#    LONG   biXPelsPerMeter; 
#    LONG   biYPelsPerMeter; 
#    DWORD  biClrUsed; 
#    DWORD  biClrImportant; 
# } BITMAPINFOHEADER; 


class BITMAPINFO (structob.struct_object):
	oracle = structob.Oracle (
		'bitmap_info_header',
		'Nlllllllllll',
		('size',
		 'width',
		 'height',
		 'planes',
		 'bit_count',
		 'compression',
		 'size_image',
		 'x_pels_per_meter',
		 'y_pels_per_meter',
		 'clr_used',
		 'clr_important'
		 )
		)


# HBITMAP CreateDIBitmap(
#     HDC hdc,	// handle to device context 
#     CONST BITMAPINFOHEADER *lpbmih,	// pointer to bitmap size and format data 
#     DWORD fdwInit,	// initialization flag 
#     CONST VOID *lpbInit,	// pointer to initialization data 
#     CONST BITMAPINFO *lpbmi,	// pointer to bitmap color-format data 
#     UINT fuUsage 	// color-data usage 
#    );


#  constants for CreateDIBitmap 
CBM_INIT        = 0x04L   #  initialize bitmap 

#  DIB color table identifiers 

DIB_RGB_COLORS      = 0 #  color table in RGBs 
DIB_PAL_COLORS      = 1 #  color table in palette indices 

# Drawing a bitmap into a window:
# >>> mm = win32file.memory_mapped_file (win32file.file ('e:/temp/setup.bmp'))
# >>> mb = mm.get_membuf()
# >>> bmfh = win32dib.BITMAPFILEHEADER (mb)
# >>> desktop = winwin.window (0x2004A)
# >>> dc = desktop.get_dc()
# >>> a = mb.address()
# >>> windc.gdi32.StretchDIBits (dc, 0, 0, 600, 600, 0, 0, 200, 200, a + bmfh.off_bits, a+14, 0, wingdi.SRCCOPY)

