# -*- Mode: Python; tab-width: 4 -*-

#
# Simple layout manager support, modeled after the java awt.
#

# Each container window owns a layout manager.  The layout manager
# will position the children according to its policy.
#
# Currently implemented: border_layout and flow_layout.
# TODO: proportional_layout (like that managed by splitter.py)

# TODO: implement an optional property of the border layout that
# either allows different objects in the corners, or knows how to
# decorate the corners.  This would allow us to have MS-style
# scrollbars meet in the bottom right.

# I think that by following the Java AWT model of using a separate
# object to handle layout, we have over-complicated things.  I am
# considering using instead 'layout containers', windows that
# implement the layout policy directly.  This should help with chasing
# cycles and should really simplify the use of the layout managers.
#
# Actually, I mis-implemented the layout manager object: I think AWT
# does this, but keeps the policy manager separate (i.e., a single
# policy manager object for each type?)
#

import wingdi
import winwin

# returns LOWORD, HIWORD
def SPLIT_WORD (x):
	return (x&0xffff, (x>>16))

class border_container (winwin.python_window):

	def create (*args):
		self = apply (winwin.python_window.create, args)
		self.layout_children = {}
		return self

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		self.do_layout()

	constraints = ('north', 'south', 'east', 'west', 'center')

	def add (self, child, constraint):
		if constraint not in self.constraints:
			raise ValueError, "Unsupported constraint.  Use one of %s" % repr(self.constraints)
		elif self.layout_children.has_key (constraint):
			raise ValueError, "A child has already been positioned there"
		else:
			self.layout_children[constraint] = child

	def get_child (self, border):
		if self.layout_children.has_key (border):
			return self.layout_children[border]
		else:
			return None

	def get_child_size (self, border):
		child = self.get_child (border)
		if child :
			return child.get_preferred_size()
		else:
			return (0, 0)

	def move_child (self, child, (l,t,w,h)):
		child.move_window (l,t,w,h)

	def do_layout (self):
		# Lay out each component.  Determine the bounds of the center
		# rectangle, given the preferred sizes of any child windows.
		#
		#   +--------------+
		#   |              |
		#  	+---o------o---+          cl, ct       cr, ct
		#  	|	|  	   |   |
   	   	#	|	|  	   |   |
		#	|	|  	   |   |
		#	+---o------o---+          cl, cb       cr, cb
		#	|			   |
		# 	+--------------+
		#

		l,t,r,b = self.get_client_rect()

		ct = t + self.get_child_size ('north')[1]
		cb = b - self.get_child_size ('south')[1]
		cl = l + self.get_child_size ('west')[0]
		cr = r - self.get_child_size ('east')[0]

		child = self.get_child ('north')
		if child:
			self.move_child (child, (l,t,r-l,ct-t))

		child = self.get_child ('south')
		if child:
			self.move_child (child, (0,cb,r-l,b-cb))
			
		child = self.get_child ('west')
		if child:
			self.move_child (child, (0,ct,cl-l,cb-ct))
		
		child = self.get_child ('east')
		if child:
			self.move_child (child, (cr,ct,r-cr,cb-ct))

		child = self.get_child ('center')
		if child:
			self.move_child (child, (cl,ct,cr-cl,cb-ct))

