# -*- Mode: Python; tab-width: 4 -*-

import string

import mvc
import mvc_scrollbar
import winmesg
import winwin
import winfont
import mvc_seq_win

user32 = winwin.user32

SPLIT_WORD = winwin.SPLIT_WORD

# TODO: collapse seq_win and cell_win more completely, rather
# than duplicating all this code. (I think seq_win ought to use
# get_cell_size(), too).
#
# A good demo for this would be a program that displayed a PBM
# file using big fat square pixels, and then let the user edit
# it by clicking the pixels on and off...

# sequence of sequences?

class cell_window (mvc_seq_win.sequence_window):
	
	def get_position (self):
		vm, hm = self.scroll_models
		cx, cy = self.get_cell_size()
		return cx * hm.position, cy * vm.position

	def get_limits (self):
		if len(self.model):
			return (
				max (map (len, self.model)),
				len (self.model)
				)
		else:
			return 0, 0

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		dc.set_bk_color()
		dc.set_bk_mode()

		l,t,r,b = dc.get_clip_box()
		
		# which lines need to be repainted?

		cw, ch = self.get_cell_size()

		first = t/ch
		last = b/ch
		if b % ch:
			last = last + 1

		xl,xh = l/cw, r/cw

		if len (self.model):
			last = min (len (self.model), last)

			for i in range (first, last):
				self.draw_line (dc, i, (xl,xh))

		self.end_paint()

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		w, h = self.size
		cx, cy = self.get_cell_size()
		vm, hm = self.scroll_models
		hm.limit, vm.limit = self.get_limits()
		hm.page = w / cx
		vm.page = h / cy

	def draw_line (self, dc, index, range=None):
		# sample implementation
		cw, ch = self.get_cell_size()
		y = ch * index
		dc.select_object (self.font)
		s = str(self.model[index])
		if range is None:
			dc.text_out ((0,y), s)
		else:
			l,h = range
			dc.text_out ((l*cw, y), s[l:h])
			
	def scoot (self):
		"scroll the window up to make room for output"
		vm, hm = self.scroll_models
		cx, cy = self.get_cell_size()
		w, h = self.size
		n = len (self.model)

		lx, ly = self.get_limits()

		vm.limit = ly
		vm.page = h/cy

		if (h < (n * cy)):
			vm.position = ly - (h/cy)

		if len(self.model):
			hm.limit = lx
			hm.page = w/cx

	def notify (self, model, hint):
		vm, hm = self.scroll_models

		# a change to the sequence model
		if model is self.model:
			kind = hint[0]
			if kind == model.HINT_CHANGE:
				ignore, low, high = hint
				self.invalidate_lines (low, high+1)
			elif kind == model.HINT_INSERT:
				ignore, start, nitems = hint
				self.invalidate_lines (start-1, len(self.model))
				vm.limit = len(self.model)
			elif kind == model.HINT_REMOVE:
				ignore, start, nitems = hint
				self.invalidate_lines (start, len(self.model))
				vm.limit = len(self.model)

		# a scroll event
		elif model in self.scroll_models:
			lx, ly = self.last_scroll_position
			nx, ny = self.get_position()

			if model is vm:
				dx, dy = 0, ly - ny
			elif model is hm:
				dx, dy = lx - nx, 0

			self.scroll_window (dx, dy)
			self.last_scroll_position = nx, ny
			self.update_window()

class text_window (cell_window):

	font_height = 16
	font = winfont.font ('Courier New', height=font_height).create()
	cell_size = None

	def get_cell_size (self):
		if self.cell_size is None:
			# don't call ours, it needs cell_size!
			dc = winwin.python_window.get_dc (self)
			dc.select_object (self.font)
			tm = dc.get_text_metrics()
			dc.release_dc()
			self.cell_size = tm.ave_char_width, tm.height

		return self.cell_size

	
class text_edit_window (text_window):
	
	cursor_pos = (0,0)

	def WM_SETFOCUS (self, wparam, lparam):
		self.show_caret()
	
	def show_caret (self):
		cx, cy = self.get_cell_size()
		user32.CreateCaret (self, 0, cx, cy)
		self.set_caret_pos()
		user32.ShowCaret (self)

	def set_caret_pos (self):
		cx, cy = self.get_cell_size()
		x, y = self.cursor_pos
		x, y = self.lp_to_dp ((x * cx, y * cy))
		user32.SetCaretPos (x, y)

	def WM_KILLFOCUS (self, wparam, lparam):
		user32.DestroyCaret (self)

	def WM_LBUTTONDOWN (self, wparam, lparam):
		x, y = self.dp_to_lp (SPLIT_WORD (lparam))
		cw, ch = self.get_cell_size()
		cx, cy = x/cw, y/ch
		if self.model:
			self.cursor_pos = self.constrain_cursor (cx, cy)
			self.set_caret_pos()

	def constrain_cursor (self, cx, cy):
		m = self.model
		lm = len(m)

		if cx < 0:
			cx = 0
		if cy < 0:
			cy = 0

		if lm:
			if cy < lm:
				if cx < len(m[cy]):
					return (cx, cy)
				else:
					return (len(m[cy]), cy)
			else:
				return len(m[lm-1]), lm-1

	def WM_KEYDOWN (self, wparam, lparam):
		x, y = self.cursor_pos
		if wparam == winmesg.VK_UP:
			y = y - 1
		elif wparam == winmesg.VK_DOWN:
			y = y + 1
		elif wparam == winmesg.VK_RIGHT:
			x = x + 1
		elif wparam == winmesg.VK_LEFT:
			x = x - 1
		self.cursor_pos = self.constrain_cursor (x, y)
		self.set_caret_pos()

	def WM_CHAR (self, wparam, lparam):
		cx, cy = self.get_cell_size()
		ch = chr (wparam)
		w, h = self.size
		x, y = self.cursor_pos

		m = self.model

		line = m[y]
		
		if ch == '\r':
			if x < len(line):
				m[y] = line[:x]
				m.insert (y+1, line[x:])
			else:
				m.insert (y+1, '')
			self.cursor_pos = 0, y+1
			if (y+1 == (len(m)-1)):
				self.scoot()
		else:
			chars = map (None, line)
			chars.insert (x, ch)
			m[y] = string.join (chars, '')
			x = x + 1
			self.cursor_pos = x, y

		self.set_caret_pos()

		return 1

	# for use as a component
	def get_preferred_size (self):
		cx, cy = self.get_cell_size()
		return sys.maxint, cy

class line_edit_window (text_edit_window):

	def do_paint (self, dc):
		dc.draw_3d_box (self.get_client_rect())
		return text_edit_window.do_paint (self, dc)

	# default width of 15 chars
	line_width = 15

	# for use as a component
	def get_preferred_size (self):
		cx, cy = self.get_cell_size()
		return cx * self.line_width, cy

import sys

class password_window (line_edit_window):

	def create (*args):
		self = apply (line_edit_window.create, args)
		self.set_model (mvc.sequence_model (['']))
		return self

	def draw_line (self, dc, index, range=None):
		cw, ch = self.get_cell_size()
		y = ch * index
		dc.select_object (self.font)

		l = len(self.model[index])
		s = self.model[index]
		if range is None:
			dc.text_out ((0,y), s)
		else:
			l,h = range
			dc.text_out ((l*cw, y), '*' * len(s[l:h]))

		dc.text_out ((0,y), '*'*l)

class text_component (mvc_seq_win.sequence_component):
 
	sequence_view_class = text_window

import sys

class text_edit_component (mvc_seq_win.sequence_component):
 
	def WM_SETFOCUS (self, wparam, lparam):
		self.sequence_window.set_focus()

	sequence_view_class = text_edit_window

class output_component (mvc_seq_win.sequence_component):

	sequence_view_class = text_window

	def set_model (self, model):
		self.sequence_window.set_model (model)
		model.add_view (self)

	def notify (self, model, hint):
		# scroll on append
		self.sequence_window.scoot()

def demo():
	
	def frob_line (line):
		import string

		line = string.join (string.split (line, '\t'), '    ')
		while line and line[-1] in '\r\n':
			line = line[:-1]
		return line
		
	lines = open ('mvc_cell_win.py', 'rb').readlines()
	lines = map (frob_line, lines)
	lines = mvc.sequence_model (lines)
	
	w = text_edit_component (
		'demo cell window',
		style= winwin.WS_OVERLAPPEDWINDOW
		).create()

	w.set_model (lines)
	w.show_window()
	return w

if __name__ == '__main__':
	import msgloop
	w = demo()
	msgloop.go()
