# -*- Mode: Python; tab-width: 4 -*-

import mvc
import string

# debugging...
import sys
import winwin

class output_file:

	"an output file class tied to a sequence model"
	
	def __init__ (self):
		self.model = mvc.sequence_model()

	def close (self):
		pass
	
	def isatty (self):
		return 0

	at_newline = 1

	# debugging...
	orig_std_files = sys.stdout, sys.stderr

	def write (self, s):

		m = self.model

		if s == '\n':
			# special-case
			self.at_newline = 1
			return
			
		def frob_line (line):
			line = string.join (string.split (line, '\t'), '    ')
			while line and line[-1] in '\r\n':
				line = line[:-1]
			return line

		try:
			lines = map (frob_line, string.split (s, '\n'))
			n = len(m)

			if lines[-1] == '':
				del lines[-1]

			if not self.at_newline and len(m):
				# prepend the front of the line
				lines[0] = m[n-1] + lines[0]
				m[n-1:n] = lines
			else:
				m[n:n] = lines

			self.at_newline = (s[-1] == '\n')

		except:
			(sys.stdout, sys.stderr), self.orig_std_files = self.orig_std_files, (sys.stdout, sys.stderr)
			apply (winwin.print_compact_traceback, sys.exc_info())
			(sys.stdout, sys.stderr), self.orig_std_files = self.orig_std_files, (sys.stdout, sys.stderr)

	def writelines (self, lines):
		self.write (string.join (lines, ''))

	def flush (self):
		pass

class captured_output_file (output_file):
	
	def __init__ (self, file):
		self.file = file
		output_file.__init__ (self)

	def write (self, s):
		self.file.write (s)
		output_file.write (self, s)

def test():
	import sys
	co = captured_output_file (sys.stdout)
	sys.stdout = co
	return co
