# -*- Mode: Python; tab-width: 4 -*-

# TODO: haven't really messed with the horizontal scrollbar.
# it should probably be turned off by default. (see %% below)

import mvc
import mvc_scrollbar
import winwin
import winfont

SPLIT_WORD = winwin.SPLIT_WORD

class sequence_window (winwin.python_window, mvc.view):

	style = winwin.WS_CHILD | winwin.WS_VISIBLE

	line_height = 16
	font = winfont.font ('Courier New', height=line_height).create()

	last_scroll_position = 0, 0
	scroll_models = None, None

	def create (*args):
		self = apply (winwin.python_window.create, args)
		self.scroll_models = (
			mvc_scrollbar.scroll_model(),
			mvc_scrollbar.scroll_model()
			)
		return self

	# vertical units are lines, horizontal units are pixels.

	def prepare_dc (self, dc):
		x, y = self.get_position()
		dc.set_window_org (x, y)

	def begin_paint (self, paintstruct=None):
		dc = winwin.python_window.begin_paint (self, paintstruct)
		self.prepare_dc (dc)
		return dc

	def get_dc (self):
		dc = winwin.python_window.get_dc (self)
		self.prepare_dc (dc)
		return dc

	def get_position (self):
		vm, hm = self.scroll_models
		lh = self.line_height
		return (hm.position, (lh * vm.position))

	def dp_to_lp (self, (x,y)):
		dx, dy = self.get_position()
		return x + dx, y + dy

	def lp_to_dp (self, (x,y)):
		dx, dy = self.get_position()
		return (x - dx, y - dy)

	# Any obvious use of this will need <rect> in logical coordinates.
	def invalidate_rect (self, rect, erase=1):
		if rect:
			dx, dy = self.get_position()
			l,t,r,b = rect
			rect = l-dx, t-dy, r-dx, b-dy

		winwin.python_window.invalidate_rect (self, rect, erase)

	def set_model (self, model):
		if self.scroll_models:
			vm, hm = self.scroll_models
			vm.limit = len(model)
		return mvc.view.set_model (self, model)

	size = 100, 100

	def WM_SIZE (self, wparam, lparam):
		w, h = self.size = SPLIT_WORD (lparam)
		vm, hm = self.scroll_models
		hm.page = hm.limit = w
		vm.limit = len(self.model)
		self.adjust_scroll_page()

	def adjust_scroll_page (self):
		lh = self.line_height
		vm, hm = self.scroll_models
		w, h = self.size
		vm.page = h/lh

	def WM_DESTROY (self, wparam, lparam):
		vm, hm = self.scroll_models
		for m in self.model, vm, hm:
			m.remove_view (self)
		return winwin.python_window.WM_DESTROY (self, wparam, lparam)

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		dc.set_bk_color()
		dc.set_bk_mode()
		self.do_paint (dc)
		self.end_paint()
		
	def do_paint (self, dc):
		l,t,r,b = dc.get_clip_box()
		
		# which lines need to be repainted?

		lh = self.line_height
		first = t/lh
		last = b/lh
		if b % lh:
			last = last + 1

		if len (self.model):
			last = min (len (self.model), last)

			for i in range (first, last):
				self.draw_line (dc, i)

	def invalidate_lines (self, low, high):
		# [low, high)
		lh = self.line_height
		y1 = lh * low
		y2 = lh * high
		w,h = self.size
		if high == len(self.model):
			# clear all the way to the end of the window
			y2 = lh * (high + h/lh)
		self.invalidate_rect ((0,y1,w,y2))

	# %% draw_line should return the width of the line it has just
	# drawn.  This way we can keep track of the horizontal width.

	def draw_line (self, dc, index):
		# sample implementation
		lh = self.line_height
		y = lh * index
		dc.select_object (self.font)
		dc.text_out ((0,y), str(self.model[index]))

	def shift_with_scroll (self, line_from, line_to):
		# shift a region of the window up or down
		w,h = self.size
		lh = self.line_height
		y1 = lh * line_from
		y2 = lh * line_to
		self.scroll_window (dx=0, dy=(y2-y1), scroll_rect = (0,y2,w,h))

	def notify (self, model, hint):
		vm, hm = self.scroll_models

		# a change to the sequence model
		# TODO: scan for max horizontal line
		if model is self.model:
			kind = hint[0]
			if kind == model.HINT_CHANGE:
				ignore, low, high = hint
				self.invalidate_lines (low, high)
			elif kind == model.HINT_INSERT:
				ignore, start, nitems = hint
				self.shift_with_scroll (start, start+nitems)
				self.invalidate_lines  (start, start+nitems)
				vm.limit = len(self.model)
			elif kind == model.HINT_REMOVE:
				ignore, start, nitems = hint
				self.invalidate_lines  (start+nitems, len(self.model))
				self.shift_with_scroll (start+nitems, start)
				vm.limit = len(self.model)

		# a scroll event
		elif model in self.scroll_models:
			lx, ly = self.last_scroll_position
			lh = self.line_height		
			nx, ny = hm.position, vm.position
			ny = ny * lh

			if model is vm:
				dx, dy = 0, ly - ny
			elif model is hm:
				dx, dy = lx - nx, 0

			if (model is vm) and (hint == 'limit'):
				self.adjust_scroll_page()

			self.scroll_window (dx, dy)
			self.last_scroll_position = nx, ny
			self.update_window()
			
import layout
import sys

class sequence_component (layout.border_container):

	style = winwin.WS_CHILD | winwin.WS_VISIBLE

	sequence_view_class = sequence_window

	vert_scrollbar_border = 'east'
	horz_scrollbar_border = 'south'

	def create (*args):
		self = apply (layout.border_container.create, args)

		sw = self.sequence_view_class (parent=self).create()

		vm, hm = sw.scroll_models

		vs = mvc_scrollbar.vertical_scrollbar_component (model=vm, parent=self,  width=14).create()
		hs = mvc_scrollbar.horizontal_scrollbar_component (model=hm, parent=self, width=14).create()

		self.add (vs, self.vert_scrollbar_border)
		self.add (hs, self.horz_scrollbar_border)
		self.add (sw, 'center')

		vm.add_view (sw)
		hm.add_view (sw)

		self.sequence_window = sw

		return self
		
	def set_model (self, sequence_model):
		self.sequence_window.set_model (sequence_model)
		
	def get_preferred_size (self):
		# stretchable in both directions
		return sys.maxint, sys.maxint

def demo():
	
	def frob_line (line):
		import string

		line = string.join (string.split (line, '\t'), '    ')
		while line and line[-1] in '\r\n':
			line = line[:-1]
		return line
		
	lines = open ('mvc_seq_win.py', 'rb').readlines()
	lines = map (frob_line, lines)
	lines = mvc.sequence_model (lines)
	
	w = sequence_component (
		'demo sequence window',
		style= winwin.WS_OVERLAPPEDWINDOW
		).create()

	w.set_model (lines)
	w.show_window()
	return w

if __name__ == '__main__':
	import msgloop
	w = demo()
	msgloop.go()
