# -*- Mode: Python; tab-width: 4 -*-

import mvc
import layout
import sys

import windc
import winfont
import wingdi
import winwin

class status_component (winwin.python_window, mvc.view):

	# we borrow code from mvc_button_bar, it would be nice
	# to lay out a status bar to its right...

	style = winwin.WS_CHILD | winwin.WS_VISIBLE
	font = winfont.get_system_fonts()['menu_font'].create()

	border_ratio = (3, 2)

	font_height = 0

	def get_font_height (self):
		# memoized
		if self.font_height == 0:
			dc = winwin.python_window.get_dc (self)
			dc.select_object (self.font)
			tm = dc.get_text_metrics()
			dc.release_dc()
			self.font_height = tm.height

		return self.font_height

	def get_preferred_size (self):
		n, d = self.border_ratio
		return sys.maxint, (n * self.get_font_height()) / d
	
	def prepare_dc (self, dc):
		dc.set_bk_color()
		dc.set_bk_mode ()
		dc.select_object (self.font)

	def WM_SIZE (self, wparam, lparam):
		self.invalidate_rect (0)

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		self.prepare_dc (dc)
		self.do_paint (dc)
		self.end_paint()

	header = 'Status: '

	def do_paint (self, dc):
		rect = self.get_client_rect()
		dc.fill_rect (rect, windc.get_sys_brush (windc.COLOR_WINDOW))
		dc.draw_3d_box (rect, kind='etched', filled=0)

		l,t,r,b = rect
		fh = self.get_font_height()
		bh = b-t
		y = t + ((bh-fh)/2)
		dc.text_out ((4,y), self.header + self.model.status)
		
	def notify (self, model, hint):
		if model is self.model and hint == 'status':
			# redraw immediately
			self.invalidate_rect()
			self.update_window()

# Usage:
# sw = mvc_status.status_component().create()
# sw.set_model (mvc.auto_model (status='status text'))
# sw.model.status = 'some different text'
