# -*- Mode: Python; tab-width: 4 -*-

#from dyn_win32 import windll, language
import windll
import language

import calldll

kernel32 = windll.module ('kernel32')

FORMAT_MESSAGE_ALLOCATE_BUFFER = 0x00000100
FORMAT_MESSAGE_IGNORE_INSERTS  = 0x00000200
FORMAT_MESSAGE_FROM_STRING     = 0x00000400
FORMAT_MESSAGE_FROM_HMODULE    = 0x00000800
FORMAT_MESSAGE_FROM_SYSTEM     = 0x00001000
FORMAT_MESSAGE_ARGUMENT_ARRAY  = 0x00002000
FORMAT_MESSAGE_MAX_WIDTH_MASK  = 0x000000FF

import struct

def get_error_string (errno=None):
	if errno is None:
		errno = kernel32.GetLastError()
	sa = windll.membuf (4)
	length = kernel32.FormatMessage (
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		0,
		errno,
		language.MAKELANGID (language.LANG_NEUTRAL, language.SUBLANG_DEFAULT),
		sa,
		0,
		0
		)
	if length:
		return calldll.read_string (struct.unpack ('l', sa.read())[0])
	else:
		raise SystemError, "FormatMessage failed for %d" % (errno)
