# -*- Mode: Python; tab-width: 4 -*-

# simple button windows

# TODO: lots of expected behavior is still not implemented.  Some
# buttons apparently have a 'repeat' capability (like scroll bar
# buttons).  Also, a button should not 'fire' unless the BUTTONUP
# event happens inside the button.  With the button held down, moving
# into and out of the button should toggle the state.

import windc
import winfont
import wingdi
import winwin

user32 = windc.user32

SPLIT_WORD = winwin.SPLIT_WORD

class button (winwin.python_window):

	style = winwin.WS_CHILD | winwin.WS_VISIBLE
	state = 0
	captured = 0
	callback = None
	
	def configure (self, callback, up=1):
		self.callback = callback
		self.state = up

	def get_preferred_size (self):
		return 50, 50

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		self.invalidate_rect (0)

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		self.prepare_dc (dc)
		self.do_paint (dc)
		self.end_paint()

	def do_paint (self, dc):
		rect = self.get_client_rect()
		dc.draw_3d_box (rect, self.state)

	def prepare_dc (self, dc):
		pass

	def get_dc (self):
		dc = winwin.python_window.get_dc (self)
		self.prepare_dc (dc)
		return dc

	def WM_LBUTTONDOWN (self, wparam, lparam):
		# toggle the button
		self.state = not self.state
		self.set_capture()
		self.captured = 1
		dc = self.get_dc()
		self.do_paint (dc)
		dc.release_dc()

	def WM_LBUTTONUP (self, wparam, lparam):
		if self.captured:
			# toggle the button
			self.state = not self.state
			self.release_capture()
			dc = self.get_dc()
			self.do_paint (dc)
			dc.release_dc()
			self.captured = 0
			if self.callback is not None:
				self.callback (self)

class text_button (button):

	label = None
	font = wingdi.get_stock_object (wingdi.SYSTEM_FONT)

	def configure (self, label, callback, up=1):
		button.configure (self, callback, up)
		self.label = label

	def get_preferred_size (self):
		if self.label is not None:
			dc = self.get_dc()
			dc.select_object (self.font)
			w, h = dc.get_text_extent (self.label)
			self.label_size = w, h
			# add 50% around the text
			return (3*w)/2, (3*h)/2
		else:
			return 50, 50

	def prepare_dc (self, dc):
		dc.set_bk_color()
		dc.set_bk_mode ()
		dc.select_object (self.font)

	def do_paint (self, dc):
		button.do_paint (self, dc)
		l,t,r,b = self.get_client_rect()
		h = b-t
		w = r-l
		tw, th = self.label_size
		dc.text_out ((l+((w-tw)/2), t+((h-th)/2)), self.label)

class scroll_button (button):

	def configure (self, direction, callback, up=1):
		button.configure (self, callback, up)
		self.direction = direction

	def do_paint (self, dc):
		button.do_paint (self, dc)
		l,t,r,b = self.get_client_rect()
		h = b-t
		w = r-l
		dx = w/3
		dy = h/3
		pen = windc.get_sys_pen (windc.COLOR_WINDOWTEXT)
		brush = windc.get_sys_brush (windc.COLOR_3DSHADOW)
		dc.select_object (pen)
		dc.select_object (brush)
		if self.direction == 'up':
			dc.polygon ((dx, h-dy), (w/2, dy), (w-dx, h-dy))
		elif self.direction == 'down':
			dc.polygon ((dx, dy), (w-dx, dy), (w/2, h-dy))
		elif self.direction == 'left':
			dc.polygon ((dx, h/2), (w-dx, dy), (w-dx, h-dy))
		else:
			dc.polygon ((dx, dy), (dx, h-dy), (w-dx, h/2))

	preferred_size = 24, 24

	def get_preferred_size (self):
		return self.preferred_size

if __name__ == '__main__':
	import layout
	import msgloop

	def callback (object):
		print '%s <click!>' % repr(object)

	parent = layout.container ('Button Demo', w=200, h=100).create()
	parent.handle_erase_background = 0
	fl = layout.flow_layout (parent)
	for label in ('one', 'two', 'three', 'four'):
		child = text_button ('text button %s' % label)
		child.parent = parent
		parent.add (child, None)
		child.create()
		child.configure (label, callback)

	for d in ('up', 'down', 'left', 'right'):
		child = scroll_button ('%s scroll button' % d)
		child.parent = parent
		parent.add (child, None)
		child.create()
		child.configure (d, callback)

	parent.show_window()
	msgloop.go()
