# -*- Mode: Python; tab-width: 4 -*-

# simple 3d text buttons

# this can now be done with the single-button class and flow_layout.

import windc
import winfont
import wingdi
import winwin

user32 = windc.user32

SPLIT_WORD = winwin.SPLIT_WORD

class text_button (winwin.python_window):

	buttons = []

	style = winwin.WS_CHILD | winwin.WS_VISIBLE

	def insert (self, text, callback=None, pos=None, up=1):
		if self.buttons is None:
			self.buttons = []

		if pos is None:
			self.buttons.append ([text, callback, up])
		else:
			self.buttons.insert (pos, [text, callback, up])
		self.recalc()

	font = wingdi.get_stock_object (wingdi.SYSTEM_FONT)

	def recalc (self):
		dc = self.get_dc()
		dc.select_object (self.font)
		widest = 0
		for info in self.buttons:
			[text, callback, up] = info
			w,h = dc.get_text_extent (text)
			widest = max (widest, w)

		self.font_v_offset = h/2
		num, den = self.border_ratio
		self.button_width = (widest * num) / den
		
		dc.release_dc()

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		self.invalidate_rect (0)

	border_ratio = (3, 2)

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		bw = self.button_width
		self.prepare_dc (dc)
		for i in range(len(self.buttons)):
			self.draw_button (dc, i)

		self.end_paint()

	def prepare_dc (self, dc):
		dc.set_bk_color()
		dc.set_bk_mode ()
		dc.select_object (self.font)
		dc.set_text_align (wingdi.TA_CENTER)

	def get_dc (self):
		dc = winwin.python_window.get_dc (self)
		self.prepare_dc (dc)
		return dc

	def draw_button (self, dc, index):
		w, h = self.size
		i = index
		bw = self.button_width
		[text, callback, up] = self.buttons[i]
		rect = (i*bw, 0, (i*bw)+bw-1, h)
		dc.draw_3d_box (rect, up)
		self.draw_button_face (dc, index, rect)

	def draw_button_face (self, dc, index, rect):
		l,t,r,b = rect
		h = b-t
		bw = self.button_width
		dc.text_out (
			(((index*bw)+(bw/2)), (h/2)-self.font_v_offset),
			text
			)
		
	captured = None

	def WM_LBUTTONDOWN (self, wparam, lparam):
		mx, my = SPLIT_WORD (lparam)
		# did they hit a button?
		bw = self.button_width
		for i in range(len(self.buttons)):
			[text, callback, up] = self.buttons[i]
			if (i * bw) < mx < ((i+1)*bw):
				# toggle the button
				self.buttons[i][2] = not up
				self.set_capture()
				self.captured = i
				dc = self.get_dc()
				self.draw_button (dc, i)
				dc.release_dc()

	def WM_LBUTTONUP (self, wparam, lparam):
		mx, my = SPLIT_WORD (lparam)
		# did they hit a button?
		i = self.captured
		bw = self.button_width
		if i is not None:
			[text, callback, up] = self.buttons[i]
			# toggle the button
			self.buttons[i][2] = not up
			self.release_capture()
			dc = self.get_dc()
			self.draw_button (dc, i)
			dc.release_dc()
			self.captured = None

if __name__ == '__main__':
	import msgloop
	bw = text_button ('Text Button Window Demo')
	bw.style = winwin.WS_OVERLAPPEDWINDOW
	bw.w = 640
	bw.h = 60
	bw.font = winfont.font ('Arial', height=18, weight=winfont.FW_BOLD).create()
	bw.create()
	for name in ('Buttons', 'Are', 'Cool', 'Up', 'Or'):
		bw.insert (name)
	bw.insert ('Down', up=0)
	bw.show_window()
	msgloop.go()
