# -*- Mode: Python; tab-width: 4 -*-

import dynscroll
import string
import winfont
import windc
import wingdi
import winwin

SPLIT_WORD = winwin.SPLIT_WORD

class text_window (winwin.python_window):

	# scrolls in units of character cells rather than pixels.  requires a fixed font

	font_height = 16
	font = winfont.font ('Courier New', height=font_height).create()
	lines = []
	style = winwin.WS_CHILD | winwin.WS_VISIBLE
	scroll_position = 0, 0
	cell_size = None

	def get_cell_size (self):
		if self.cell_size is None:
			# don't call ours, it needs cell_size!
			dc = winwin.python_window.get_dc (self)
			dc.select_object (self.font)
			tm = dc.get_text_metrics()
			dc.release_dc()
			self.cell_size = tm.ave_char_width, tm.height

		return self.cell_size

	# ideally, we do this in character-cell units.
	def adjust_scrollbars (self):
		"adjust scrollbar settings to reflect a change in view or data size"
		vs, hs = self.get_scroll_bars()
		fw, fh = self.get_cell_size()
		lw, lh = max (map (len, self.lines)), len (self.lines)
		ww, wh = self.size
		pw, ph = ww / fw, wh / fh

		# update scroll position if necessary
		n, d = vs.get_scroll_position()
		if d != lh:
			vs.set_scroll_position ((n,lh))
		n, d = hs.get_scroll_position()
		if d != lw:
			hs.set_scroll_position ((n,lw))

		# adjust page size if necessary
		n, d = vs.get_page_size()
		if (n, d) != (ph, lh):
			vs.set_page_size ((ph, lh))

		n, d = hs.get_page_size()
		if (n, d) != (pw, lw):
			hs.set_page_size ((pw, lw))

	def begin_paint (self, paintstruct=None):
		dc = winwin.python_window.begin_paint (self, paintstruct)
		self.prepare_dc (dc)
		return dc

	def prepare_dc (self, dc):
		x, y = self.scroll_position
		sx, sy = self.get_cell_size()
		dc.set_window_org (sx * x, sy * y)

	def get_dc (self):
		x, y = self.scroll_position
		dc = winwin.python_window.get_dc (self)
		self.prepare_dc (dc)
		return dc

	def WM_SIZE (self, wparam, lparam):
		self.size = SPLIT_WORD (lparam)
		if self.lines:
			self.adjust_scrollbars()
			self.invalidate_rect (0)

	def invalidate_rect (self, rect, erase=1):
		if rect:
			x, y = self.scroll_position
			cx, cy = self.get_cell_size()
			x, y = x * cx, y * cy
			l,t,r,b = rect
			rect = l-x, t-y, r-x, b-y

		winwin.python_window.invalidate_rect (self, rect, erase)

 	def invalidate_line_range (self, low, high):
 		w, h = self.size
 		fw, fh = self.get_cell_size()
		r = (0, low*fh, w, high*fh)
 		self.invalidate_rect (r)
		return r

	def get_scroll_bars (self):
		return self.get_parent().bars

	def scroll_event (self, kind, position):
		x, y = self.scroll_position
		n, d = position
		w, h = self.size
		sx, sy = self.get_cell_size()

		if kind == 'horizontal':
			self.scroll_position = n, y
			dx = x - n
			dy = 0
			if dx > 0:
				ir = (x,y,x+dx,y+h)
			else:
				ir = (x+w-dx,y,x+w,y+h)
			
		elif kind == 'vertical':
			self.scroll_position = x, n
			dx = 0
			dy = y - n
			if dy > 0:
				ir = (x,y,x+w,y+dy)
			else:
				ir = (x,y+h-dy,x+w,y+h)

		self.scroll_window (sx * dx, sy * dy)
		self.update_window()

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		self.do_paint (dc)
		self.end_paint()

	def do_paint (self, dc):

		if not self.widest_line and self.lines:
			once = 1
		else:
			once = 0

		dc.select_object (self.font)
		dc.set_bk_color()
		dc.set_bk_mode (windc.TRANSPARENT)
		dc.set_text_align (wingdi.TA_UPDATECP)

		l,t,r,b = dc.get_clip_box()

		# determine the range of lines we need to draw

		fw, fh = self.get_cell_size()
		first = t / fh
		last  = b / fh
		if b % fh:
			last = last + 1

		last = min (len(self.lines), last)

		for i in range (first, last):
			self.draw_line (dc, i*fh, i)

		if once:
			self.adjust_scrollbars()

	def draw_line (self, dc, y, index):
		dc.move_to ((0, y))
		text = self.lines[index]
		dc.text_out ((0,0), text)
		px, py = dc.move_to_ex ((0,0))
		if px > self.widest_line:
			# this isn't right.
			self.widest_line = px

	widest_line = 0

# class edit_window (text_window):
# 
# 	current_pos = (0,0)
# 
# 	def WM_CHAR (self, wparam, lparam):
# 		# insert / overwrite, etc...
# 		lh = self.font_height
# 		ch = chr (wparam)
# 		w, h = self.size
# 		x, y = self.current_pos
# 
# 		line = self.lines[y]
# 
# 		if ch == '\r':
# 			if x < len(line):
# 				self.lines[y] = line[:x]
# 				self.lines.insert (y+1, line[x:])
# 			else:
# 				self.lines.insert (y+1, '')
# 			self.current_pos = 0, y+1
# 			self.invalidate_rect ((0,y * lh,w,h))
# 		else:
# 			chars = map (None, line)
# 			chars.insert (x, ch)
# 			self.lines[y] = string.join (chars, '')
# 			x = x + 1
# 			cw = self.font_width
# 			self.current_pos = x, y
# 			self.invalidate_rect (
# 				((x-1) * cw , y * lh, w, (y+1) * lh)
# 				)
# 
# 		self.set_caret_pos()
# 
# 		return 1
# 
# 	def invalidate_line_range (self, low, high):
# 		w, h = self.size
# 		fh = self.font_height
# 		self.invalidate_rect ((0, low*fh, w, high*fh))
# 
# 	def WM_DESTROY (self, wparam, lparam):
# 		winwin.user32.PostQuitMessage (0)
# 
# 	def WM_SETFOCUS (self, wparam, lparam):
# 		self.show_caret()
# 	
# 	def show_caret (self):
# 		user32.CreateCaret (self, 0, self.font_width, self.font_height)
# 		self.set_caret_pos()
# 		user32.ShowCaret (self)
# 
# 	def set_caret_pos (self):
# 		lh = self.font_height
# 		cw = self.font_width
# 		x, y = self.current_pos
# 		x, y = self.lp_to_dp ((x * cw, y * lh))
# 		user32.SetCaretPos (x, y)
# 
# 	def WM_KILLFOCUS (self, wparam, lparam):
# 		user32.DestroyCaret (self)
# 
# 	def WM_LBUTTONDOWN (self, wparam, lparam):
# 		mx, my = self.dp_to_lp (SPLIT_WORD (lparam))
# 		x = mx / self.font_width
# 		y = my / self.font_height
# 		y = min (len (self.lines) - 1, y )
# 		x = min (len (self.lines[y]), x)
# 		self.current_pos = x, y
# 		self.set_caret_pos ()

def clean (line):
	# remove CR, LF
	while line and line[-1] in '\r\n':
		line = line[:-1]
	# replace tabs
	return string.join (string.split (line, '\t'), '    ')

def test():
	frame = dynscroll.scroll_frame ('scroll test').create()
	w = text_window ('text window', parent=frame).create()
	w.lines = map (clean, open ('dynscroll.py', 'r').readlines())
	frame.configure (w, ((0,1), (0,1)))
	frame.show_window()

if __name__ == '__main__':
	import msgloop
	test()
	msgloop.go()
