# -*- Mode: Python; tab-width: 4 -*-

# Support for Win32 Services (WINNT)

# from <winnt.h>

STANDARD_RIGHTS_REQUIRED         = (0x000F0000L)

# from <winsvc.h>
#
# Constants
#

#
# Service database names
#

SERVICES_ACTIVE_DATABASE      = "ServicesActive"
SERVICES_FAILED_DATABASE      = "ServicesFailed"

#
# Character to designate that a name is a group
#

SC_GROUP_IDENTIFIER           = '+'

#
# Value to indicate no change to an optional parameter
#
SERVICE_NO_CHANGE              = 0xffffffff

#
# Service State -- for Enum Requests (Bit Mask)
#
SERVICE_ACTIVE                 = 0x00000001
SERVICE_INACTIVE               = 0x00000002
SERVICE_STATE_ALL              = (SERVICE_ACTIVE   | \
                                        SERVICE_INACTIVE)

#
# Controls
#
SERVICE_CONTROL_STOP           = 0x00000001
SERVICE_CONTROL_PAUSE          = 0x00000002
SERVICE_CONTROL_CONTINUE       = 0x00000003
SERVICE_CONTROL_INTERROGATE    = 0x00000004
SERVICE_CONTROL_SHUTDOWN       = 0x00000005

#
# Service State -- for CurrentState
#
SERVICE_STOPPED                = 0x00000001
SERVICE_START_PENDING          = 0x00000002
SERVICE_STOP_PENDING           = 0x00000003
SERVICE_RUNNING                = 0x00000004
SERVICE_CONTINUE_PENDING       = 0x00000005
SERVICE_PAUSE_PENDING          = 0x00000006
SERVICE_PAUSED                 = 0x00000007

#
# Controls Accepted  (Bit Mask)
#
SERVICE_ACCEPT_STOP            = 0x00000001
SERVICE_ACCEPT_PAUSE_CONTINUE  = 0x00000002
SERVICE_ACCEPT_SHUTDOWN        = 0x00000004

#
# Service Control Manager object specific access types
#
SC_MANAGER_CONNECT             = 0x0001
SC_MANAGER_CREATE_SERVICE      = 0x0002
SC_MANAGER_ENUMERATE_SERVICE   = 0x0004
SC_MANAGER_LOCK                = 0x0008
SC_MANAGER_QUERY_LOCK_STATUS   = 0x0010
SC_MANAGER_MODIFY_BOOT_CONFIG  = 0x0020

SC_MANAGER_ALL_ACCESS          = (STANDARD_RIGHTS_REQUIRED      | \
                                        SC_MANAGER_CONNECT            | \
                                        SC_MANAGER_CREATE_SERVICE     | \
                                        SC_MANAGER_ENUMERATE_SERVICE  | \
                                        SC_MANAGER_LOCK               | \
                                        SC_MANAGER_QUERY_LOCK_STATUS  | \
                                        SC_MANAGER_MODIFY_BOOT_CONFIG)



#
# Service object specific access type
#
SERVICE_QUERY_CONFIG           = 0x0001
SERVICE_CHANGE_CONFIG          = 0x0002
SERVICE_QUERY_STATUS           = 0x0004
SERVICE_ENUMERATE_DEPENDENTS   = 0x0008
SERVICE_START                  = 0x0010
SERVICE_STOP                   = 0x0020
SERVICE_PAUSE_CONTINUE         = 0x0040
SERVICE_INTERROGATE            = 0x0080
SERVICE_USER_DEFINED_CONTROL   = 0x0100

SERVICE_ALL_ACCESS             = (STANDARD_RIGHTS_REQUIRED     | \
                                        SERVICE_QUERY_CONFIG         | \
                                        SERVICE_CHANGE_CONFIG        | \
                                        SERVICE_QUERY_STATUS         | \
                                        SERVICE_ENUMERATE_DEPENDENTS | \
                                        SERVICE_START                | \
                                        SERVICE_STOP                 | \
                                        SERVICE_PAUSE_CONTINUE       | \
                                        SERVICE_INTERROGATE          | \
                                        SERVICE_USER_DEFINED_CONTROL)

