# -*- Mode: Python; tab-width: 4 -*-

import string
import winfont
import winwin

# We should probably use a model for the text, so we
# get change notification.

class static_text_component (winwin.python_window):
	
	font = winfont.font ('Arial', height=16, weight=winfont.FW_BOLD).create()
	style = winwin.WS_CHILD | winwin.WS_VISIBLE

	text = '<??>'

	def __init__ (self, parent, text=''):
		self.parent = parent
		self.text = text
		winwin.python_window.__init__ (
			self,
			style=winwin.WS_CHILD,
			parent=parent
			)

	def set_text (self, text):
		self.text = text

	def WM_SIZE (self, wparam, lparam):
		self.invalidate_rect()

	def WM_PAINT (self, wparam, lparam):
		dc = self.begin_paint()
		dc.set_bk_mode()
		dc.select_object (self.font)
		dc.draw_text (
			self.text,
			self.get_client_rect()
			)

	def get_preferred_size (self):
		dc = self.get_dc()
		dc.select_object (self.font)
		lines = string.split (self.text, '\n')

		mw, ml = 0, ''
		for line in lines:
			if len(line) > mw:
				mw, ml = len(line), line
				
		x, y = dc.get_text_extent (ml)
		return x, (y *len(lines))
		
