# -*- Mode: Python; tab-width: 4 -*-
#	$Id: structob.py,v 1.1 1996/04/02 18:36:46 rushing Exp $
#	Author: Sam Rushing <rushing@nightmare.com>

# A structure object as defined by an npstruct.Oracle,
# with get/set capability for slots.

import calldll
import npstruct

#from dyn_win32 import oracle
import oracle

Oracle = oracle.Oracle

# FIXME: I should probably mangle all the method and member names
# in order to avoid name clashes with structure slots.

# Note: setting a bunch of slots might be pretty slow, but I bet
# it's because of npstruct (bit-twiddling in python), rather than
# because we read and write the whole struct every time.

class struct_object:
	oracle = None
	def __init__ (self, membuf=None, address=None):
		if self.oracle == None:
			raise error, "struct_object is an abstract class"
		self._dict = self.oracle.new()
		self._size = self.oracle.size
		if membuf == None:
			if address is None:
				self._mb = calldll.membuf (self._size)
				self._mb.write (self.oracle.pack (self._dict))
			else:
				# we're probably pointing at a pre-existing structure
				self._mb = calldll.membuf (self._size, address)
		else:
			self._mb = membuf
			self._dict, size = self.oracle.unpack (self._mb.read())

	def set_values (self, **key_args):
		return self._set_values (key_args)

	def _set_values (self, key_args):
		for key, value in key_args.items():
			if self._dict.has_key (key):
				self._dict[key] = value
			else:
				raise KeyError
		self._mb.write (self.oracle.pack (self._dict))

	def __getattr__ (self, name):
		dict, size = self.oracle.unpack (self._mb.read())
		if dict.has_key (name):
			return dict[name]
		else:
			raise KeyError

	# allows us to avoid that ol' "hoisted on our own petards" problem.
	_dict = {}

	def __setattr__ (self, name, value):
		d = self._dict
		if d.has_key (name):
			# sync up the contents with what's in memory
			d, size = self.oracle.unpack (self._mb.read())
			d[name] = value
			self._mb.write (self.oracle.pack (d))
		else:
			self.__dict__[name] = value

	def copy (self):
		nmb = calldll.membuf (self._size)
		nmb.write (self._mb.read())
		return struct_object (self.oracle, nmb)

	def __repr__ (self):
		self._dict, size = self.oracle.unpack (self._mb.read())
		return '<%s %s>' % (self.__class__.__name__,
							repr(self._dict))
							
	def address (self):
		return self._mb.address()

	__int__ = address

	def describe (self):
		d, len = self.oracle.unpack (self._mb.read())
		self.oracle.describe (d)
