# -*- Mode: Python; tab-width: 4 -*-

import structob

# From <winuser.h>
#
# Parameter for SystemParametersInfo()
#

SPI_GETBEEP                 = 1
SPI_SETBEEP                 = 2
SPI_GETMOUSE                = 3
SPI_SETMOUSE                = 4
SPI_GETBORDER               = 5
SPI_SETBORDER               = 6
SPI_GETKEYBOARDSPEED       = 10
SPI_SETKEYBOARDSPEED       = 11
SPI_LANGDRIVER             = 12
SPI_ICONHORIZONTALSPACING  = 13
SPI_GETSCREENSAVETIMEOUT   = 14
SPI_SETSCREENSAVETIMEOUT   = 15
SPI_GETSCREENSAVEACTIVE    = 16
SPI_SETSCREENSAVEACTIVE    = 17
SPI_GETGRIDGRANULARITY     = 18
SPI_SETGRIDGRANULARITY     = 19
SPI_SETDESKWALLPAPER       = 20
SPI_SETDESKPATTERN         = 21
SPI_GETKEYBOARDDELAY       = 22
SPI_SETKEYBOARDDELAY       = 23
SPI_ICONVERTICALSPACING    = 24
SPI_GETICONTITLEWRAP       = 25
SPI_SETICONTITLEWRAP       = 26
SPI_GETMENUDROPALIGNMENT   = 27
SPI_SETMENUDROPALIGNMENT   = 28
SPI_SETDOUBLECLKWIDTH      = 29
SPI_SETDOUBLECLKHEIGHT     = 30
SPI_GETICONTITLELOGFONT    = 31
SPI_SETDOUBLECLICKTIME     = 32
SPI_SETMOUSEBUTTONSWAP     = 33
SPI_SETICONTITLELOGFONT    = 34
SPI_GETFASTTASKSWITCH      = 35
SPI_SETFASTTASKSWITCH      = 36
SPI_SETDRAGFULLWINDOWS     = 37
SPI_GETDRAGFULLWINDOWS     = 38
SPI_GETNONCLIENTMETRICS    = 41
SPI_SETNONCLIENTMETRICS    = 42
SPI_GETMINIMIZEDMETRICS    = 43
SPI_SETMINIMIZEDMETRICS    = 44
SPI_GETICONMETRICS         = 45
SPI_SETICONMETRICS         = 46
SPI_SETWORKAREA            = 47
SPI_GETWORKAREA            = 48
SPI_SETPENWINDOWS          = 49

SPI_GETHIGHCONTRAST        = 66
SPI_SETHIGHCONTRAST        = 67
SPI_GETKEYBOARDPREF        = 68
SPI_SETKEYBOARDPREF        = 69
SPI_GETSCREENREADER        = 70
SPI_SETSCREENREADER        = 71
SPI_GETANIMATION           = 72
SPI_SETANIMATION           = 73
SPI_GETFONTSMOOTHING       = 74
SPI_SETFONTSMOOTHING       = 75
SPI_SETDRAGWIDTH           = 76
SPI_SETDRAGHEIGHT          = 77
SPI_SETHANDHELD            = 78
SPI_GETLOWPOWERTIMEOUT     = 79
SPI_GETPOWEROFFTIMEOUT     = 80
SPI_SETLOWPOWERTIMEOUT     = 81
SPI_SETPOWEROFFTIMEOUT     = 82
SPI_GETLOWPOWERACTIVE      = 83
SPI_GETPOWEROFFACTIVE      = 84
SPI_SETLOWPOWERACTIVE      = 85
SPI_SETPOWEROFFACTIVE      = 86
SPI_SETCURSORS             = 87
SPI_SETICONS               = 88
SPI_GETDEFAULTINPUTLANG    = 89
SPI_SETDEFAULTINPUTLANG    = 90
SPI_SETLANGTOGGLE          = 91
SPI_GETWINDOWSEXTENSION    = 92
SPI_SETMOUSETRAILS         = 93
SPI_GETMOUSETRAILS         = 94
SPI_SCREENSAVERRUNNING     = 97
SPI_GETFILTERKEYS          = 50
SPI_SETFILTERKEYS          = 51
SPI_GETTOGGLEKEYS          = 52
SPI_SETTOGGLEKEYS          = 53
SPI_GETMOUSEKEYS           = 54
SPI_SETMOUSEKEYS           = 55
SPI_GETSHOWSOUNDS          = 56
SPI_SETSHOWSOUNDS          = 57
SPI_GETSTICKYKEYS          = 58
SPI_SETSTICKYKEYS          = 59
SPI_GETACCESSTIMEOUT       = 60
SPI_SETACCESSTIMEOUT       = 61
SPI_GETSERIALKEYS          = 62
SPI_SETSERIALKEYS          = 63
SPI_GETSOUNDSENTRY         = 64
SPI_SETSOUNDSENTRY         = 65

#
# Flags
#
SPIF_UPDATEINIFILE    = 0x0001
SPIF_SENDWININICHANGE = 0x0002
SPIF_SENDCHANGE       = SPIF_SENDWININICHANGE


# typedef struct tagNONCLIENTMETRICS {  
#     UINT    cbSize; 
#     int     iBorderWidth; 
#     int     iScrollWidth; 
#     int     iScrollHeight; 
#     int     iCaptionWidth; 
#     int     iCaptionHeight; 
#     LOGFONT lfCaptionFont; 
#     int     iSmCaptionWidth; 
#     int     iSmCaptionHeight; 
#     LOGFONT lfSmCaptionFont; 
#     int     iMenuWidth; 
#     int     iMenuHeight; 
#     LOGFONT lfMenuFont; 
#     LOGFONT lfStatusFont; 
#     LOGFONT lfMessageFont; 
# } NONCLIENTMETRICS, FAR* LPNONCLIENTMETRICS; 

import winfont

class NONCLIENTMETRICS (structob.struct_object):
	oracle = structob.Oracle (
		'non_client_metrics',
		'Nllllll[font]ll[font]ll[font][font][font]',
		('size',
		 'border_width',
		 'scroll_width',
		 'scroll_height',
		 'caption_width',
		 'caption_height',
		 'caption_font',
		 'sm_caption_width',
		 'sm_caption_height',
		 'sm_caption_font',
		 'menu_width',
		 'menu_height',
		 'menu_font',
		 'status_font',
		 'message_font'
		 ),
		font = winfont.LOGFONT.oracle
		)
	oracle.size = oracle.size + (winfont.LOGFONT.oracle.size * 5)
