# -*- Mode: Python; tab-width: 4 -*-

import string
import npstruct

#from dyn_win32 import windll, structob
import windll
import structob

kernel32 = windll.module ('kernel32')

# typedef struct _OSVERSIONINFO{  
#     DWORD dwOSVersionInfoSize; 
#     DWORD dwMajorVersion; 
#     DWORD dwMinorVersion; 
#     DWORD dwBuildNumber; 
#     DWORD dwPlatformId; 
#     TCHAR szCSDVersion[ 128 ]; 
# } OSVERSIONINFO; 
 
class OSVERSIONINFO (structob.struct_object):

	def read_csdv (results, data, pos):
		index = string.find (data, '\000', pos)
		return (data[pos:index],), (index-pos)
	
	def write_csdv (csdv):
		if len(csdv) > 127:
			raise npstruct.error, 'name too long for OSVERSIONINFO structure'
		else:
			r = csdv + ('\000' * (128 - len(csdv)))
			#print 'len, repr(result) = %d, %s' % len(r), repr(r)
			return r

	oracle = structob.Oracle (
		'os_version_info',
		'Nlllll[thing]',
		('os_version_info_size',
		 'major_version',
		 'minor_version',
		 'build_number',
		 'platform_id',
		 'csd_version'
		 ),
		thing = (read_csdv, write_csdv)
		)
	oracle.size = oracle.size + 128


# from <winbase.h>
#
# dwPlatformId defines:
#

VER_PLATFORM_WIN32s             = 0
VER_PLATFORM_WIN32_WINDOWS      = 1
VER_PLATFORM_WIN32_NT           = 2

def get_version():
	osvi = OSVERSIONINFO()
	osvi.os_version_info_size = osvi._size
	kernel32.GetVersionEx (osvi)
	return osvi
