# -*- Mode: Python; tab-width: 4 -*-

# Get and set system time for win32

# requires the following packages
# ftp://ftp.nightmare.com/pub/python/python-ext/calldll.tar.gz
# ftp://ftp.nightmare.com/pub/python/python-ext/npstruct.tar.gz

#from dyn_win32 import windll, structob
import windll
import structob

import npstruct

kernel32 = windll.module ('kernel32')


class SYSTEMTIME (structob.struct_object):
	oracle = structob.Oracle (
		'Win32 System Time representation (UTC)',
		'Nhhhhhhhh',
		('Year',
		 'Month',
		 'DayOfWeek',
		 'Day',
		 'Hour',
		 'Minute',
		 'Second',
		 'Milliseconds'
		 )
		)

import time

def unix_to_win32 (t):
	st = SYSTEMTIME()
	(st.Year,
	 st.Month,
	 st.Day,
	 st.Hour,
	 st.Minute,
	 st.Second,
	 st.DayOfWeek,
	 julian,
	 dst
	 ) = time.gmtime (t)
	st.Milliseconds = int((t*1000)%1000)
	return st

def set_system_time (unix_time):
	st = unix_to_win32 (unix_time)
	return kernel32.SetSystemTime (st.address())
	
def get_system_time ():
	st = SYSTEMTIME()
	kernel32.GetSystemTime (st.address())
	return st
