# -*- Mode: Python; tab-width: 4 -*-
#	$Id: $
#	Author: Sam Rushing <rushing@nightmare.com>

import sys

import calldll
import npstruct

#from dyn_win32 import windll, gencb, structob, windc
import windll
import gencb
import structob
import windc

error = 'winclass module error'

user32 = windll.module ('user32')
gdi32 = windll.module ('gdi32')
kernel32 = windll.module ('kernel32')


class WNDCLASSEX (structob.struct_object):
	oracle = structob.Oracle (
		'window class information',
		'Nllllllllllll',
		('size',
		 'style',
		 'wnd_proc',
		 'cls_extra',
		 'wnd_extra',
		 'instance',
		 'icon',
		 'cursor',
		 'background',
		 'menu_name',
		 'class_name',
		 'icon_sm')
		)

# Keep track of registered window classes.  This also ensures that the
# objects are still around, including the callback procedures.
# try/except catches a reload, and unregisters any known classes.
try:
	registered_window_classes
	for value in registered_window_classes.values():
		value.unregister()
except NameError:
	pass

registered_window_classes = {}

# Standard Icon IDs
IDI_APPLICATION     = 32512
IDI_HAND            = 32513
IDI_QUESTION        = 32514
IDI_EXCLAMATION     = 32515
IDI_ASTERISK        = 32516
IDI_WINLOGO         = 32517

# Standard Cursor IDs

IDC_ARROW           = 32512
IDC_IBEAM           = 32513
IDC_WAIT            = 32514
IDC_CROSS           = 32515
IDC_UPARROW         = 32516
IDC_SIZE            = 32640  #  OBSOLETE: use IDC_SIZEALL 
IDC_ICON            = 32641  #  OBSOLETE: use IDC_ARROW 
IDC_SIZENWSE        = 32642
IDC_SIZENESW        = 32643
IDC_SIZEWE          = 32644
IDC_SIZENS          = 32645
IDC_SIZEALL         = 32646
IDC_NO              = 32648 # not in win3.1 
IDC_APPSTARTING     = 32650 # not in win3.1 

# get the module handle for this program
module_handle = kernel32.GetModuleHandle (0)

# Here's how to use your own icon - you need to link it into your executable.
#default_icon 		= user32.LoadIcon (module_handle, 101)
#default_icon_small	= user32.LoadIcon (module_handle, 101)
default_icon 		= user32.LoadIcon (0, IDI_APPLICATION)
default_icon_small	= user32.LoadIcon (0, IDI_APPLICATION)
default_cursor		= user32.LoadCursor (0, IDC_ARROW)
default_background	= gdi32.GetStockObject (windc.COLOR_BACKGROUND)

Already_Registered_Error = 'window class already registered'

class window_class:
	atom = 0
	def __init__ (self,
				  class_name,
				  window_procedure=None,
				  **attrs
				  ):
		wc = WNDCLASSEX()

		if type (class_name) == type(''):
			self.class_name = windll.cstring (class_name)
		else:
			self.class_name = class_name

		self.wnd_proc_cb = gencb.generated_callback ('llll', window_procedure)

		wc.class_name	= self.class_name.address()
		wc.wnd_proc		= self.wnd_proc_cb.address
		# default some settings
		wc.instance		= module_handle
		wc.icon			= default_icon
		wc.icon_sm		= default_icon_small
		wc.cursor		= default_cursor
		wc.background	= default_background
		wc.size		= wc._size
		for k, v in attrs.items():
			setattr (wc, k, v)
		self.wc = wc

	def register (self):
		name = self.class_name.trunc()
		if not registered_window_classes.has_key (name):
			self.atom = user32.RegisterClassEx (self.wc)
			if self.atom:
				registered_window_classes[name] = self
			return self
		else:
			raise Already_Registered_Error, name
		
	def unregister (self):
		if self.atom:
			if user32.UnregisterClass (self.name.address(), module_handle):
				self.atom = 0
				del registered_window_classes[self.name.trunc()]
		else:
			raise ValueError, "attempt to unregister a class with NULL self.atom"

	def __int__ (self):
		if self.atom:
			return self.atom
		else:
			raise ValueError, "window class not registered"

	def __del__ (self):
		if self.atom:
			self.unregister()

class temp_cursor:
	def __init__ (self, cursor=IDC_WAIT):
		self.new_cursor = user32.LoadCursor (0, cursor)
		self.old_cursor = user32.SetCursor (self.new_cursor)

	def off (self):
		if self.old_cursor:
			user32.SetCursor (self.old_cursor)
			self.old_cursor = None

	def __del__ (self):
		self.off()

# defaults to IDC_WAIT, this is a convenient name.
wait_cursor = temp_cursor
