# -*- Mode: Python; tab-width: 4 -*-

import npstruct
#from dyn_win32 import windll, structob, gencb
import windll
import structob
import gencb

user32 = windll.module ('user32')

# ===========================================================================
# From ddeml.h
# ===========================================================================

#
# Callback filter flags for use with standard apps.
#

CBF_FAIL_SELFCONNECTIONS     = 0x00001000
CBF_FAIL_CONNECTIONS         = 0x00002000
CBF_FAIL_ADVISES             = 0x00004000
CBF_FAIL_EXECUTES            = 0x00008000
CBF_FAIL_POKES               = 0x00010000
CBF_FAIL_REQUESTS            = 0x00020000
CBF_FAIL_ALLSVRXACTIONS      = 0x0003f000

CBF_SKIP_CONNECT_CONFIRMS    = 0x00040000
CBF_SKIP_REGISTRATIONS       = 0x00080000
CBF_SKIP_UNREGISTRATIONS     = 0x00100000
CBF_SKIP_DISCONNECTS         = 0x00200000
CBF_SKIP_ALLNOTIFICATIONS    = 0x003c0000

#
# Application command flags
#

APPCMD_CLIENTONLY            = 0x00000010L
APPCMD_FILTERINITS           = 0x00000020L
APPCMD_MASK                  = 0x00000FF0L

#
# Application classification flags
#
APPCLASS_STANDARD            = 0x00000000L
APPCLASS_MASK                = 0x0000000FL

#
# Callback filter flags for use with MONITOR apps - 0 implies no monitor
# callbacks.
#
MF_HSZ_INFO                  = 0x01000000
MF_SENDMSGS                  = 0x02000000
MF_POSTMSGS                  = 0x04000000
MF_CALLBACKS                 = 0x08000000
MF_ERRORS                    = 0x10000000
MF_LINKS                     = 0x20000000
MF_CONV                      = 0x40000000

DMLERR_NO_ERROR                    = 0       #  must be 0 

DMLERR_FIRST                       = 0x4000

DMLERR_ADVACKTIMEOUT               = 0x4000
DMLERR_BUSY                        = 0x4001
DMLERR_DATAACKTIMEOUT              = 0x4002
DMLERR_DLL_NOT_INITIALIZED         = 0x4003
DMLERR_DLL_USAGE                   = 0x4004
DMLERR_EXECACKTIMEOUT              = 0x4005
DMLERR_INVALIDPARAMETER            = 0x4006
DMLERR_LOW_MEMORY                  = 0x4007
DMLERR_MEMORY_ERROR                = 0x4008
DMLERR_NOTPROCESSED                = 0x4009
DMLERR_NO_CONV_ESTABLISHED         = 0x400a
DMLERR_POKEACKTIMEOUT              = 0x400b
DMLERR_POSTMSG_FAILED              = 0x400c
DMLERR_REENTRANCY                  = 0x400d
DMLERR_SERVER_DIED                 = 0x400e
DMLERR_SYS_ERROR                   = 0x400f
DMLERR_UNADVACKTIMEOUT             = 0x4010
DMLERR_UNFOUND_QUEUE_ID            = 0x4011

CP_WINANSI      = 1004    #  default codepage for windows & old DDE convs. 
CP_WINUNICODE   = 1200

# **** transaction types ****

XTYPF_NOBLOCK            = 0x0002  #  CBR_BLOCK will not work 
XTYPF_NODATA             = 0x0004  #  DDE_FDEFERUPD 
XTYPF_ACKREQ             = 0x0008  #  DDE_FACKREQ 

XCLASS_MASK              = 0xFC00
XCLASS_BOOL              = 0x1000
XCLASS_DATA              = 0x2000
XCLASS_FLAGS             = 0x4000
XCLASS_NOTIFICATION      = 0x8000

XTYP_ERROR              = (0x0000 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK )
XTYP_ADVDATA            = (0x0010 | XCLASS_FLAGS         )
XTYP_ADVREQ             = (0x0020 | XCLASS_DATA | XTYPF_NOBLOCK )
XTYP_ADVSTART           = (0x0030 | XCLASS_BOOL          )
XTYP_ADVSTOP            = (0x0040 | XCLASS_NOTIFICATION)
XTYP_EXECUTE            = (0x0050 | XCLASS_FLAGS         )
XTYP_CONNECT            = (0x0060 | XCLASS_BOOL | XTYPF_NOBLOCK)
XTYP_CONNECT_CONFIRM    = (0x0070 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
XTYP_XACT_COMPLETE      = (0x0080 | XCLASS_NOTIFICATION  )
XTYP_POKE               = (0x0090 | XCLASS_FLAGS         )
XTYP_REGISTER           = (0x00A0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
XTYP_REQUEST            = (0x00B0 | XCLASS_DATA          )
XTYP_DISCONNECT         = (0x00C0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
XTYP_UNREGISTER         = (0x00D0 | XCLASS_NOTIFICATION | XTYPF_NOBLOCK)
XTYP_WILDCONNECT        = (0x00E0 | XCLASS_DATA | XTYPF_NOBLOCK)

# From winuser.h
#
# Predefined Clipboard Formats
#
CF_TEXT             = 1
CF_BITMAP           = 2
CF_METAFILEPICT     = 3
CF_SYLK             = 4
CF_DIF              = 5
CF_TIFF             = 6
CF_OEMTEXT          = 7
CF_DIB              = 8
CF_PALETTE          = 9
CF_PENDATA          = 10
CF_RIFF             = 11
CF_WAVE             = 12
CF_UNICODETEXT      = 13
CF_ENHMETAFILE      = 14
CF_HDROP            = 15
CF_LOCALE           = 16
CF_MAX              = 17
CF_OWNERDISPLAY     = 0x0080
CF_DSPTEXT          = 0x0081
CF_DSPBITMAP        = 0x0082
CF_DSPMETAFILEPICT  = 0x0083
CF_DSPENHMETAFILE   = 0x008E

#
# "Private" formats don't get GlobalFree()'d
#
CF_PRIVATEFIRST     = 0x0200
CF_PRIVATELAST      = 0x02FF

#
# "GDIOBJ" formats do get DeleteObject()'d
#
CF_GDIOBJFIRST      = 0x0300
CF_GDIOBJLAST       = 0x03FF

# ===========================================================================

dde_errors = {
	0x4000: 'DMLERR_ADVACKTIMEOUT',
	0x4001: 'DMLERR_BUSY',
	0x4002: 'DMLERR_DATAACKTIMEOUT',
	0x4003: 'DMLERR_DLL_NOT_INITIALIZED',
	0x4004: 'DMLERR_DLL_USAGE',
	0x4005: 'DMLERR_EXECACKTIMEOUT',
	0x4006: 'DMLERR_INVALIDPARAMETER',
	0x4007: 'DMLERR_LOW_MEMORY',
	0x4008: 'DMLERR_MEMORY_ERROR',
	0x4009: 'DMLERR_NOTPROCESSED',
	0x400a: 'DMLERR_NO_CONV_ESTABLISHED',
	0x400b: 'DMLERR_POKEACKTIMEOUT',
	0x400c: 'DMLERR_POSTMSG_FAILED',
	0x400d: 'DMLERR_REENTRANCY',
	0x400e: 'DMLERR_SERVER_DIED',
	0x400f: 'DMLERR_SYS_ERROR',
	0x4010: 'DMLERR_UNADVACKTIMEOUT',
	0x4011: 'DMLERR_UNFOUND_QUEUE_ID'
	}
	

# sequence:
# DdeInitialize
# DdeCreateStringHandle ("PROGMAN")
# DdeConnect
#   DdeCreateDataHandle
#   DdeClientTransaction
# DdeFreeStringHandle
# DdeUninitialize

# function exists for compatibility, but does nothing
def dde_callback (*args):
	pass

dde_cb = gencb.callback ('llllllll', dde_callback)

# FIXME: (use npstruct)
import struct
		
class dde_session:
	id_inst = 0
	conversation = 0

	def initialize (self, cb = dde_cb, command_flags = APPCMD_CLIENTONLY):
		id_inst = windll.membuf (4)
		id_inst.write (struct.pack ('l', 0))
		result = user32.DdeInitialize (id_inst, dde_cb, command_flags, 0)
		if result == DMLERR_NO_ERROR:
			self.id_inst = struct.unpack ('l', id_inst.read())[0]
		else:
			self.hurl ('DdeInitialize', result)

	def __del__ (self):
		if self.id_inst:
			self.uninitialize()

	def uninitialize (self):
		result = user32.DdeUninitialize (self.id_inst)
		if not result:
			self.hurl ('DdeUninitialize')
		else:
			self.id_inst = 0

	def get_last_error (self):
		return user32.DdeGetLastError (self.id_inst)

	def hurl (self, fun_name, error = None):
		if error is None:
			error = self.get_last_error()
		if dde_errors.has_key (error):
			error_string = dde_errors[error]
		else:
			error_string = 'Unknown DDE Error'
		raise SystemError, '%s failed with %d (%s)' % (fun_name, error, error_string)
		
	def connect (self, service, topic, conversation_context = 0):
		service = dde_string (self, service)
		topic = dde_string (self, topic)
		result = user32.DdeConnect (
			self.id_inst,
			service,
			topic,
			conversation_context
			)
		if not result:
			self.hurl('DdeConnect')
		else:
			self.conversation = result

	def execute (self, command):
		command = windll.cstring (command)
		hdata = user32.DdeCreateDataHandle (
			self.id_inst,
			command,
			command.strlen()+1,
			0,
			0,
			CF_TEXT,
			0
			)
		result = windll.membuf(4)
		retval = user32.DdeClientTransaction (
			hdata,				# pData
			0xffffffff,			# cbData
			self.conversation,	# hConv
			0,					# hszItem
			0,					# wFmt
			XTYP_EXECUTE,		# wType
			10000,				# dwTimeout
			result				# pdwResult
			)
		if not retval:
			self.hurl ('DdeClientTransaction')
		else:
			return struct.unpack ('l', result.read())[0]

class dde_string:
	handle = 0

	def __init__ (self, session, string, code_page = CP_WINANSI):
		self.string = windll.cstring (string)
		self.session = session
		self.handle = user32.DdeCreateStringHandle (
			session.id_inst,
			self.string,
			code_page
			)

	def __int__ (self):
		return self.handle


# This demo will pass each of the arguments as command
# strings to the 'PROGMAN' DDE interface.  For example:
# "python windde.py [CreateGroup(MyGroup),0] [AddItem(myapp.exe,MyApp,myapp.exe)]"

if __name__ == '__main__':
	import sys
	s = dde_session ()
	s.initialize ()

	# One demo shows passing NULL for the CONVCONTEXT,
	# another uses a zero-filled struct.  This is an
	# attempt to solve a machine-specific problem with
	# DdeConnect().

	CC = windll.membuf (36)
	CC.write (struct.pack ('l',36) + (32 * '\000'))

	try:
		s.connect ('PROGMAN', 'PROGMAN', CC)
	except:
		print 'Unable to connect to Program Manager'
		sys.exit(0)

	for arg in sys.argv[1:]:
		print arg
		s.execute (arg)
	s.uninitialize()
	
