# -*- Mode: Python; tab-width: 4 -*-

import string
import npstruct

#from dyn_win32 import structob, windll, wingdi
import structob
import windll
import wingdi

gdi32 = windll.module ('gdi32')
user32 = windll.module ('user32')

class LOGFONT (structob.struct_object):
	def read_face (results, data, pos):
		index = string.find (data, '\000', pos)
		if index == -1:
			raise npstruct.error, 'zero-terminator not found in LOGFONT face name'
		else:
			return (data[pos:index],), 32

	def write_face (name):
		if len(name) > 31:
			raise npstruct.error, 'face name too long for LOGFONT structure'
		else:
			return name + ('\000' * (32 - len(name)))

	oracle = structob.Oracle (
		'font',
		'Nlllllbbbbbbbb[face]',
		('height',
		 'width',
		 'escapement',
		 'orientation',
		 'weight',
		 'italic',
		 'underline',
		 'strike_out',
		 'charset',
		 'out_precision',
		 'clip_precision',
		 'quality',
		 'pitch_and_family',
		 'face_name'
		 ),
		face = (read_face, write_face)
		)
	# face is 32 bytes
	oracle.size = oracle.size + 32

# There are actually two of these, depending
# on whether we're using Unicode or not.
# To fix this, the 'bchar' fields will need to
# be procfields.
class NEWTEXTMETRIC (structob.struct_object):
	oracle = structob.Oracle (
		'physical font characteristics',
		'Nlllllllllllbbbbbbbbbllll',
		('height',
		 'ascent',
		 'descent',
		 'internal_leading',
		 'external_leading',
		 'ave_char_width',
		 'max_char_width',
		 'weight',
		 'overhang',
		 'digitized_aspect_x',
		 'digitized_aspect_y',
		 'first_char',
		 'last_char',
		 'default_char',
		 'break_char',
		 'italic',
		 'underlined',
		 'struckout',
		 'pitch_and_family',
		 'char_set',
		 'flags',
		 'size_em',
		 'cell_height',
		 'avg_width'
		 )
		)

class font (wingdi.GDIOBJ):
	def __init__ (self, name, **attrs):
		lf = LOGFONT()
		lf.face_name = name
		for key, value in attrs.items():
			setattr (lf, key, value)
		self.lf = lf
		self.handle = 0

	def __repr__ (self):
		return '<font instance hfont:%08x at %08x>' % (self.handle, id(self))

	def create (self):
		handle = gdi32.CreateFontIndirect (self.lf)
		wingdi.GDIOBJ.create (self, handle)
		return self

	def describe (self):
		self.lf.describe()


# from <wingdi.h>
#  Font Families 
FF_DONTCARE         = (0<<4)  #  Don't care or don't know. 
FF_ROMAN            = (1<<4)  #  Variable stroke width, serifed. 
                              #  Times Roman, Century Schoolbook, etc. 
FF_SWISS            = (2<<4)  #  Variable stroke width, sans-serifed. 
                              #  Helvetica, Swiss, etc. 
FF_MODERN           = (3<<4)  #  Constant stroke width, serifed or sans-serifed. 
                              #  Pica, Elite, Courier, etc. 
FF_SCRIPT           = (4<<4)  #  Cursive, etc. 
FF_DECORATIVE       = (5<<4)  #  Old English, etc. 

#  Font Weights 
FW_DONTCARE         = 0
FW_THIN             = 100
FW_EXTRALIGHT       = 200
FW_LIGHT            = 300
FW_NORMAL           = 400
FW_MEDIUM           = 500
FW_SEMIBOLD         = 600
FW_BOLD             = 700
FW_EXTRABOLD        = 800
FW_HEAVY            = 900

FW_ULTRALIGHT       = FW_EXTRALIGHT
FW_REGULAR          = FW_NORMAL
FW_DEMIBOLD         = FW_SEMIBOLD
FW_ULTRABOLD        = FW_EXTRABOLD
FW_BLACK            = FW_HEAVY

import sysinfo

def get_non_client_metrics ():
	ncm = sysinfo.NONCLIENTMETRICS()
	ncm.size = ncm._size
	r = user32.SystemParametersInfo (
		sysinfo.SPI_GETNONCLIENTMETRICS,
		ncm.size,
		ncm,
		0
		)
	if not r:
		raise SystemError, "SystemParametersInfo failed"
	else:
		return ncm

# Returns a dictionary of 'ready' font objects.
# call create() when you're ready to use one of them.

def get_system_fonts (ncm=None):

	if ncm is None:
		ncm = get_non_client_metrics()

	fonts = {}
	for fn in (
		'caption_font',
		'sm_caption_font',
		'menu_font',
		'status_font',
		'message_font'
		):
		lf = LOGFONT()
		lf._set_values (getattr (ncm, fn))
		f = font('ignore')
		f.lf = lf
		fonts[fn] = f
	return fonts
