# -*- Mode: Python; tab-width: 4 -*-

import npstruct

#from dyn_win32.structob	import struct_object, Oracle
#from dyn_win32 import windll
import windll
from structob import struct_object, Oracle

gdi32	= windll.module ('gdi32')

# The GDI objects are: pen, brush, font, bitmap, region, or palette.

class GDIOBJ:

	# Keeping such a map is always a dangerous thing,
	# because it can be near impossible to ensure that
	# __del__ is called on such objects.  need to think
	# about this.

	gdi_obj_map = {}

	def __init__ (self, handle=None):
		if handle:
			self.create (handle)
		else:
			self.handle = 0

	def create (self, handle):
		if handle:
			self.handle = handle
			# Let's avoid this for now.
			# GDIOBJ.gdi_obj_map[handle] = self
			#
			# returning self allows convenient creation, e.g.:
			# brush = wingdi.brush (blue=128, green=128).create()
			return self
		else:
			raise ValueError, "create() called with NULL handle"

	def get_handle (self):
		return self.handle

	__int__ = get_handle

	def __repr__ (self):
		return '<%s handle:%08x at %08x>' % (
			self.__class__.__name__,
			self.handle,
			id(self)
			)

	def __del__ (self):
		if self.handle:
			self.delete ()

	def delete (self):

		if self.handle:
			#print 'deleting ', self
			result = gdi32.DeleteObject (self.handle)
			if result:
				# del GDIOBJ.gdi_obj_map[self.handle]
				self.handle = 0
			return result
		else:
			raise 'Attempt to Destroy GDI object with NULL handle'

#  Stock Logical Objects 
WHITE_BRUSH         = 0
LTGRAY_BRUSH        = 1
GRAY_BRUSH          = 2
DKGRAY_BRUSH        = 3
BLACK_BRUSH         = 4
NULL_BRUSH          = 5
HOLLOW_BRUSH        = NULL_BRUSH
WHITE_PEN           = 6
BLACK_PEN           = 7
NULL_PEN            = 8
OEM_FIXED_FONT      = 10
ANSI_FIXED_FONT     = 11
ANSI_VAR_FONT       = 12
SYSTEM_FONT         = 13
DEVICE_DEFAULT_FONT = 14
DEFAULT_PALETTE     = 15
SYSTEM_FIXED_FONT   = 16
DEFAULT_GUI_FONT    = 17

# should we try to distinguish the type of a stock object?
def get_stock_object (ob_type):
	handle = gdi32.GetStockObject (ob_type)
	if not handle:
		raise SystemError, "GetStockObject '%s' returned NULL" % repr(ob_type)
	else:
		return GDIOBJ (handle)

class LOGBRUSH (struct_object):
	oracle = Oracle (
		'brush',
		'Nlbbbbl',
		('style',
		 'red',
		 'green',
		 'blue',
		 'zero',
		 'hatch'
		 ),
		)

class brush (GDIOBJ):
	def __init__ (self, **attrs):
		lb = LOGBRUSH()
		for key, value in attrs.items():
			setattr (lb, key, value)
		self.lb = lb
		GDIOBJ.__init__ (self)

	def create (self):
		handle = gdi32.CreateBrushIndirect (self.lb)
		return GDIOBJ.create (self, handle)

class LOGPEN (struct_object):
	oracle = Oracle (
		'pen',
		'Nl2lbbbb',
		('style',
		 'width',
		 'red',
		 'green',
		 'blue',
		 'zero',
		 )
		)

class pen (GDIOBJ):
	def __init__ (self, **attrs):
		lp = LOGPEN()
		for key, value in attrs.items():
			setattr (lp, key, value)
		self.lp = lp
		GDIOBJ.__init__ (self)

	def create (self):
		handle = gdi32.CreatePenIndirect (self.lp)
		return GDIOBJ.create (self, handle)
	
class BITMAP (struct_object):
	# of course these need to be smarter. 8^)
	# they're temporary placeholders.
	def read_bitmap_data (results, data, pos):
		return data[pos:], len(data) - pos

	def write_bitmap_data (data):
		return data

	oracle = Oracle (
		'bitmap',
		'Nllllhh[data]',
		('type',
		 'width',
		 'height',
		 'width_bytes',
		 'planes',
		 'bits_pixel',
		 'bits'
		 ),
		data = (read_bitmap_data, write_bitmap_data)
		)

class bitmap (GDIOBJ):
	def __init__ (self, **attrs):
		bm = BITMAP()
		for key, value in attrs.items():
			setattr (bm, key, value)
		self.bm = bm
		GDIOBJ.__init__ (self)

	def create (self):
		handle = gdi32.CreateBitmapIndirect (self.bm)
		return GDIOBJ.create (self, handle)

class LOGPALETTE (struct_object):
	def read_pal_entries (results, data, pos):
		num = results[1]
		results = range(num)
		for i in range(num):
			v, el = npstruct.unpack ('Nbbbb', data[pos])
			results[i] = v
			pos = pos + el
		return results

	def write_pal_entries (entries):
		results = range(entries)
		for i in xrange(len(entries)):
			results[i] = npstruct.pack ('Nbbbb', entries[i])

	oracle = Oracle (
		'palette',
		'Nhh[entries]',
		('version',
		 'num_entries',
		 'pal_entry'
		 ),
		entries = (read_pal_entries, write_pal_entries)
		)

class palette (GDIOBJ):
	def __init__ (self, **attrs):
		lp = BITMAP()
		for key, value in attrs.items():
			setattr (lp, key, value)
		self.lp = lp
		GDIOBJ.__init__ (self)

	def create (self):
		handle = gdi32.CreatePalette (self.lp)
		return GDIOBJ.create (self, handle)
	
# Note: gdi32.GetObject() can retreive a LOGXXX struct from
# a given HGDIOBJ.

class DOCINFO (struct_object):
	oracle = Oracle (
		'docinfo',
		'Nlllll',
		('cb_size',
		 'doc_name',
		 'output',
		 'datatype',
		 'type'
		 ),
		)

# constants from <wingdi.h>
#  Brush Styles 
BS_SOLID            = 0
BS_NULL             = 1
BS_HOLLOW           = BS_NULL
BS_HATCHED          = 2
BS_PATTERN          = 3
BS_INDEXED          = 4
BS_DIBPATTERN       = 5
BS_DIBPATTERNPT     = 6
BS_PATTERN8X8       = 7
BS_DIBPATTERN8X8    = 8
BS_MONOPATTERN      = 9

#  Hatch Styles 
HS_HORIZONTAL       = 0       #  ----- 
HS_VERTICAL         = 1       #  ||||| 
HS_FDIAGONAL        = 2       #  \\\\\ 
HS_BDIAGONAL        = 3       #  ///// 
HS_CROSS            = 4       #  +++++ 
HS_DIAGCROSS        = 5       #  xxxxx 

#  Pen Styles 
PS_SOLID            = 0
PS_DASH             = 1       #  -------  
PS_DOT              = 2       #  .......  
PS_DASHDOT          = 3       #  _._._._  
PS_DASHDOTDOT       = 4       #  _.._.._  
PS_NULL             = 5
PS_INSIDEFRAME      = 6
PS_USERSTYLE        = 7
PS_ALTERNATE        = 8
PS_STYLE_MASK       = 0x0000000F

PS_ENDCAP_ROUND     = 0x00000000
PS_ENDCAP_SQUARE    = 0x00000100
PS_ENDCAP_FLAT      = 0x00000200
PS_ENDCAP_MASK      = 0x00000F00

PS_JOIN_ROUND       = 0x00000000
PS_JOIN_BEVEL       = 0x00001000
PS_JOIN_MITER       = 0x00002000
PS_JOIN_MASK        = 0x0000F000

PS_COSMETIC         = 0x00000000
PS_GEOMETRIC        = 0x00010000
PS_TYPE_MASK        = 0x000F0000


#  Binary raster ops 
R2_BLACK            = 1   #   0       
R2_NOTMERGEPEN      = 2   #  DPon     
R2_MASKNOTPEN       = 3   #  DPna     
R2_NOTCOPYPEN       = 4   #  PN       
R2_MASKPENNOT       = 5   #  PDna     
R2_NOT              = 6   #  Dn       
R2_XORPEN           = 7   #  DPx      
R2_NOTMASKPEN       = 8   #  DPan     
R2_MASKPEN          = 9   #  DPa      
R2_NOTXORPEN        = 10  #  DPxn     
R2_NOP              = 11  #  D        
R2_MERGENOTPEN      = 12  #  DPno     
R2_COPYPEN          = 13  #  P        
R2_MERGEPENNOT      = 14  #  PDno     
R2_MERGEPEN         = 15  #  DPo      
R2_WHITE            = 16  #   1       
R2_LAST             = 16

#  Ternary raster operations 
SRCCOPY             = 0x00CC0020 #  dest = source                   
SRCPAINT            = 0x00EE0086 #  dest = source OR dest           
SRCAND              = 0x008800C6 #  dest = source AND dest          
SRCINVERT           = 0x00660046 #  dest = source XOR dest          
SRCERASE            = 0x00440328 #  dest = source AND (NOT dest )   
NOTSRCCOPY          = 0x00330008 #  dest = (NOT source)             
NOTSRCERASE         = 0x001100A6 #  dest = (NOT src) AND (NOT dest) 
MERGECOPY           = 0x00C000CA #  dest = (source AND pattern)     
MERGEPAINT          = 0x00BB0226 #  dest = (NOT source) OR dest     
PATCOPY             = 0x00F00021 #  dest = pattern                  
PATPAINT            = 0x00FB0A09 #  dest = DPSnoo                   
PATINVERT           = 0x005A0049 #  dest = pattern XOR dest         
DSTINVERT           = 0x00550009 #  dest = (NOT dest)               
BLACKNESS           = 0x00000042 #  dest = BLACK                    
WHITENESS           = 0x00FF0062 #  dest = WHITE                    

#  Text Alignment Options 
TA_NOUPDATECP                = 0
TA_UPDATECP                  = 1

TA_LEFT                      = 0
TA_RIGHT                     = 2
TA_CENTER                    = 6

TA_TOP                       = 0
TA_BOTTOM                    = 8
TA_BASELINE                  = 24
TA_RTLREADING                = 256
TA_MASK       = (TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING)

VTA_BASELINE = TA_BASELINE
VTA_LEFT     = TA_BOTTOM
VTA_RIGHT    = TA_TOP
VTA_CENTER   = TA_CENTER
VTA_BOTTOM   = TA_RIGHT
VTA_TOP      = TA_LEFT

ETO_OPAQUE                   = 0x0002
ETO_CLIPPED                  = 0x0004
ETO_GLYPH_INDEX              = 0x0010
ETO_RTLREADING               = 0x0080
ETO_IGNORELANGUAGE           = 0x1000

ASPECT_FILTERING             = 0x0001


