# -*- Mode: Python; tab-width: 4 -*-

db = {
	0:['WM_NULL'],
	1:['WM_CREATE'],
	2:['WM_DESTROY'],
	3:['WM_MOVE'],
	5:['WM_SIZE'],
	6:['WM_ACTIVATE'],
	7:['WM_SETFOCUS'],
	8:['WM_KILLFOCUS'],
	10:['WM_ENABLE'],
	11:['WM_SETREDRAW'],
	12:['WM_SETTEXT'],
	13:['WM_GETTEXT'],
	14:['WM_GETTEXTLENGTH'],
	15:['WM_PAINT'],
	16:['WM_CLOSE'],
	17:['WM_QUERYENDSESSION'],
	18:['WM_QUIT'],
	19:['WM_QUERYOPEN'],
	20:['WM_ERASEBKGND'],
	21:['WM_SYSCOLORCHANGE'],
	22:['WM_ENDSESSION'],
	24:['WM_SHOWWINDOW'],
	26:['WM_SETTINGCHANGE', 'WM_WININICHANGE'],
	27:['WM_DEVMODECHANGE'],
	28:['WM_ACTIVATEAPP'],
	29:['WM_FONTCHANGE'],
	30:['WM_TIMECHANGE'],
	31:['WM_CANCELMODE'],
	32:['WM_SETCURSOR'],
	33:['WM_MOUSEACTIVATE'],
	34:['WM_CHILDACTIVATE'],
	35:['WM_QUEUESYNC'],
	36:['WM_GETMINMAXINFO'],
	38:['WM_PAINTICON'],
	39:['WM_ICONERASEBKGND'],
	40:['WM_NEXTDLGCTL'],
	42:['WM_SPOOLERSTATUS'],
	43:['WM_DRAWITEM'],
	44:['WM_MEASUREITEM'],
	45:['WM_DELETEITEM'],
	46:['WM_VKEYTOITEM'],
	47:['WM_CHARTOITEM'],
	48:['WM_SETFONT'],
	49:['WM_GETFONT'],
	50:['WM_SETHOTKEY'],
	51:['WM_GETHOTKEY'],
	55:['WM_QUERYDRAGICON'],
	57:['WM_COMPAREITEM'],
	65:['WM_COMPACTING'],
	68:['WM_COMMNOTIFY'],
	70:['WM_WINDOWPOSCHANGING'],
	71:['WM_WINDOWPOSCHANGED'],
	72:['WM_POWER'],
	74:['WM_COPYDATA'],
	75:['WM_CANCELJOURNAL'],
	78:['WM_NOTIFY'],
	80:['WM_INPUTLANGCHANGEREQUEST'],
	81:['WM_INPUTLANGCHANGE'],
	82:['WM_TCARD'],
	83:['WM_HELP'],
	84:['WM_USERCHANGED'],
	85:['WM_NOTIFYFORMAT'],
	123:['WM_CONTEXTMENU'],
	124:['WM_STYLECHANGING'],
	125:['WM_STYLECHANGED'],
	126:['WM_DISPLAYCHANGE'],
	127:['WM_GETICON'],
	128:['WM_SETICON'],
	129:['WM_NCCREATE'],
	130:['WM_NCDESTROY'],
	131:['WM_NCCALCSIZE'],
	132:['WM_NCHITTEST'],
	133:['WM_NCPAINT'],
	134:['WM_NCACTIVATE'],
	135:['WM_GETDLGCODE'],
	160:['WM_NCMOUSEMOVE'],
	161:['WM_NCLBUTTONDOWN'],
	162:['WM_NCLBUTTONUP'],
	163:['WM_NCLBUTTONDBLCLK'],
	164:['WM_NCRBUTTONDOWN'],
	165:['WM_NCRBUTTONUP'],
	166:['WM_NCRBUTTONDBLCLK'],
	167:['WM_NCMBUTTONDOWN'],
	168:['WM_NCMBUTTONUP'],
	169:['WM_NCMBUTTONDBLCLK'],
	256:['WM_KEYDOWN', 'WM_KEYFIRST'],
	257:['WM_KEYUP'],
	258:['WM_CHAR'],
	259:['WM_DEADCHAR'],
	260:['WM_SYSKEYDOWN'],
	261:['WM_SYSKEYUP'],
	262:['WM_SYSCHAR'],
	263:['WM_SYSDEADCHAR'],
	264:['WM_KEYLAST'],
	269:['WM_IME_STARTCOMPOSITION'],
	270:['WM_IME_ENDCOMPOSITION'],
	271:['WM_IME_COMPOSITION', 'WM_IME_KEYLAST'],
	272:['WM_INITDIALOG'],
	273:['WM_COMMAND'],
	274:['WM_SYSCOMMAND'],
	275:['WM_TIMER'],
	276:['WM_HSCROLL'],
	277:['WM_VSCROLL'],
	278:['WM_INITMENU'],
	279:['WM_INITMENUPOPUP'],
	287:['WM_MENUSELECT'],
	288:['WM_MENUCHAR'],
	289:['WM_ENTERIDLE'],
	306:['WM_CTLCOLORMSGBOX'],
	307:['WM_CTLCOLOREDIT'],
	308:['WM_CTLCOLORLISTBOX'],
	309:['WM_CTLCOLORBTN'],
	310:['WM_CTLCOLORDLG'],
	311:['WM_CTLCOLORSCROLLBAR'],
	312:['WM_CTLCOLORSTATIC'],
	512:['WM_MOUSEFIRST', 'WM_MOUSEMOVE'],
	513:['WM_LBUTTONDOWN'],
	514:['WM_LBUTTONUP'],
	515:['WM_LBUTTONDBLCLK'],
	516:['WM_RBUTTONDOWN'],
	517:['WM_RBUTTONUP'],
	518:['WM_RBUTTONDBLCLK'],
	519:['WM_MBUTTONDOWN'],
	520:['WM_MBUTTONUP'],
	521:['WM_MBUTTONDBLCLK', 'WM_MOUSELAST'],
	528:['WM_PARENTNOTIFY'],
	529:['WM_ENTERMENULOOP'],
	530:['WM_EXITMENULOOP'],
	531:['WM_NEXTMENU'],
	532:['WM_SIZING'],
	533:['WM_CAPTURECHANGED'],
	534:['WM_MOVING'],
	536:['WM_POWERBROADCAST'],
	537:['WM_DEVICECHANGE'],
	544:['WM_MDICREATE'],
	545:['WM_MDIDESTROY'],
	546:['WM_MDIACTIVATE'],
	547:['WM_MDIRESTORE'],
	548:['WM_MDINEXT'],
	549:['WM_MDIMAXIMIZE'],
	550:['WM_MDITILE'],
	551:['WM_MDICASCADE'],
	552:['WM_MDIICONARRANGE'],
	553:['WM_MDIGETACTIVE'],
	560:['WM_MDISETMENU'],
	561:['WM_ENTERSIZEMOVE'],
	562:['WM_EXITSIZEMOVE'],
	563:['WM_DROPFILES'],
	564:['WM_MDIREFRESHMENU'],
	641:['WM_IME_SETCONTEXT'],
	642:['WM_IME_NOTIFY'],
	643:['WM_IME_CONTROL'],
	644:['WM_IME_COMPOSITIONFULL'],
	645:['WM_IME_SELECT'],
	646:['WM_IME_CHAR'],
	656:['WM_IME_KEYDOWN'],
	657:['WM_IME_KEYUP'],
	768:['WM_CUT'],
	769:['WM_COPY'],
	770:['WM_PASTE'],
	771:['WM_CLEAR'],
	772:['WM_UNDO'],
	773:['WM_RENDERFORMAT'],
	774:['WM_RENDERALLFORMATS'],
	775:['WM_DESTROYCLIPBOARD'],
	776:['WM_DRAWCLIPBOARD'],
	777:['WM_PAINTCLIPBOARD'],
	778:['WM_VSCROLLCLIPBOARD'],
	779:['WM_SIZECLIPBOARD'],
	780:['WM_ASKCBFORMATNAME'],
	781:['WM_CHANGECBCHAIN'],
	782:['WM_HSCROLLCLIPBOARD'],
	783:['WM_QUERYNEWPALETTE'],
	784:['WM_PALETTEISCHANGING'],
	785:['WM_PALETTECHANGED'],
	786:['WM_HOTKEY'],
	791:['WM_PRINT'],
	792:['WM_PRINTCLIENT'],
	856:['WM_HANDHELDFIRST'],
	863:['WM_HANDHELDLAST'],
	864:['WM_AFXFIRST'],
	895:['WM_AFXLAST'],
	896:['WM_PENWINFIRST'],
	911:['WM_PENWINLAST'],
	1024:['WM_USER'],
	32768:['WM_APP']
	}

class messages:
	pass

for k,v in db.items():
	for m in v:
		setattr (messages, m, k)

# [couldn't think of a better place for these -smr]
# from <winuser.h>
#
# Virtual Keys, Standard Set
#
VK_LBUTTON        = 0x01
VK_RBUTTON        = 0x02
VK_CANCEL         = 0x03
VK_MBUTTON        = 0x04    #  NOT contiguous with L & RBUTTON 

VK_BACK           = 0x08
VK_TAB            = 0x09

VK_CLEAR          = 0x0C
VK_RETURN         = 0x0D

VK_SHIFT          = 0x10
VK_CONTROL        = 0x11
VK_MENU           = 0x12
VK_PAUSE          = 0x13
VK_CAPITAL        = 0x14


VK_ESCAPE         = 0x1B

VK_SPACE          = 0x20
VK_PRIOR          = 0x21
VK_NEXT           = 0x22
VK_END            = 0x23
VK_HOME           = 0x24
VK_LEFT           = 0x25
VK_UP             = 0x26
VK_RIGHT          = 0x27
VK_DOWN           = 0x28
VK_SELECT         = 0x29
VK_PRINT          = 0x2A
VK_EXECUTE        = 0x2B
VK_SNAPSHOT       = 0x2C
VK_INSERT         = 0x2D
VK_DELETE         = 0x2E
VK_HELP           = 0x2F

#  VK_0 thru VK_9 are the same as ASCII '0' thru '9' (0x30 - 0x39) 
#  VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A) 

VK_LWIN           = 0x5B
VK_RWIN           = 0x5C
VK_APPS           = 0x5D

VK_NUMPAD0        = 0x60
VK_NUMPAD1        = 0x61
VK_NUMPAD2        = 0x62
VK_NUMPAD3        = 0x63
VK_NUMPAD4        = 0x64
VK_NUMPAD5        = 0x65
VK_NUMPAD6        = 0x66
VK_NUMPAD7        = 0x67
VK_NUMPAD8        = 0x68
VK_NUMPAD9        = 0x69
VK_MULTIPLY       = 0x6A
VK_ADD            = 0x6B
VK_SEPARATOR      = 0x6C
VK_SUBTRACT       = 0x6D
VK_DECIMAL        = 0x6E
VK_DIVIDE         = 0x6F
VK_F1             = 0x70
VK_F2             = 0x71
VK_F3             = 0x72
VK_F4             = 0x73
VK_F5             = 0x74
VK_F6             = 0x75
VK_F7             = 0x76
VK_F8             = 0x77
VK_F9             = 0x78
VK_F10            = 0x79
VK_F11            = 0x7A
VK_F12            = 0x7B
VK_F13            = 0x7C
VK_F14            = 0x7D
VK_F15            = 0x7E
VK_F16            = 0x7F
VK_F17            = 0x80
VK_F18            = 0x81
VK_F19            = 0x82
VK_F20            = 0x83
VK_F21            = 0x84
VK_F22            = 0x85
VK_F23            = 0x86
VK_F24            = 0x87

VK_NUMLOCK        = 0x90
VK_SCROLL         = 0x91

#
# VK_L* & VK_R* - left and right Alt, Ctrl and Shift virtual keys.
# Used only as parameters to GetAsyncKeyState() and GetKeyState().
# No other API or message will distinguish left and right keys in this way.
#
VK_LSHIFT         = 0xA0
VK_RSHIFT         = 0xA1
VK_LCONTROL       = 0xA2
VK_RCONTROL       = 0xA3
VK_LMENU          = 0xA4
VK_RMENU          = 0xA5
VK_ATTN           = 0xF6
VK_CRSEL          = 0xF7
VK_EXSEL          = 0xF8
VK_EREOF          = 0xF9
VK_PLAY           = 0xFA
VK_ZOOM           = 0xFB
VK_NONAME         = 0xFC
VK_PA1            = 0xFD
VK_OEM_CLEAR      = 0xFE
