# -*- Mode: Python; tab-width: 4 -*-

# Win32 multimedia timers.  Unlike the standard win32 timers,
# These will work from within a console program.
#
# Usage:
# >>> def my_callback (user_info):
# ...     print user_info
# ...
# >>> t = winmm.timer (5000, 0, 3141, my_callback)
# >>> <timer instance at 78b6b0>
# >>>
# >>> 3141
# 3141
# 3141
# [...]
# >>> t.kill()
# >>> 

#from dyn_win32 import windll, gencb
import windll
import gencb

winmm = windll.module ('winmm')

# from <mmsystem.h>
# flags for fuEvent parameter of timeSetEvent() function 

TIME_ONESHOT    = 0x0000   #  program timer for single event 
TIME_PERIODIC   = 0x0001   #  program for continuous periodic event 

# void CALLBACK TimeProc(
#     UINT uID,	
#     UINT uMsg,	
#     DWORD dwUser,	
#     DWORD dw1,	
#     DWORD dw2	
#    );

class timer_registry:
	def __init__ (self):
		self.timers = {}
		self.generated_callback = gencb.generated_callback (
			'lllll',
			self.timer_callback
			)

	def timer_callback (self, id, msg, user, one, two):
		if self.timers.has_key (id):
			# the 'msg', 'one', and 'two' args
			# are labeled 'reserved, do not use'.
			self.timers[id] (user)
		return 0

	def new_timer (self,
				   delay,
				   resolution,
				   user,
				   callback,
				   event=TIME_PERIODIC):
		id = winmm.timeSetEvent (
			delay,
			resolution,
			self.generated_callback,
			user,
			event
			)
		if id:
			self.timers[id] = callback
		else:
			raise SystemError, "timeSetEvent() failed"
		return id


	def kill_timer (self, id):
		if self.timers.has_key(id):
			winmm.timeKillEvent (id)
			del self.timers[id]

class timer:
	registry = timer_registry()

	def __init__ (self,
				  delay,
				  resolution,
				  user,
				  callback,
				  event=TIME_PERIODIC):
		self.id = self.registry.new_timer (
			delay, resolution, user, callback, event
			)

	def kill (self):
		if self.id:
			self.registry.kill_timer (self.id)
			self.id = 0

	def __del__ (self):
		self.kill()
