# -*- Mode: Python; tab-width: 4 -*-

import npstruct
from structob import struct_object, Oracle

# typedef struct tagPD {  // pd  
#     DWORD     lStructSize; 
#     HWND      hwndOwner; 
#     HANDLE    hDevMode; 
#     HANDLE    hDevNames; 
#     HDC       hDC; 
#     DWORD     Flags; 
#     WORD      nFromPage; 
#     WORD      nToPage; 
#     WORD      nMinPage; 
#     WORD      nMaxPage; 
#     WORD      nCopies; 
#     HINSTANCE hInstance; 
#     DWORD     lCustData; 
#     LPPRINTHOOKPROC lpfnPrintHook; 
#     LPSETUPHOOKPROC lpfnSetupHook; 
#     LPCTSTR    lpPrintTemplateName; 
#     LPCTSTR    lpSetupTemplateName; 
#     HANDLE    hPrintTemplate; 
#     HANDLE    hSetupTemplate; 
# } PRINTDLG; 

class PRINTDLG (struct_object):
	oracle = Oracle (
		'PRINTDLG',
		'Nllllllhhhhhllllllll',
		('struct_size',
		 'owner',
		 'dev_mode',
		 'dev_names',
		 'dc',
		 'flags',
		 'from_page',
		 'to_page',
		 'min_page',
		 'max_page',
		 'copies',
		 'instance',
		 'cust_data',
		 'print_hook',
		 'setup_hook',
		 'print_template_name',
		 'setup_template_name',
		 'print_template',
		 'setup_template'
		 )
		)

class PAGESETUPDLG (struct_object):
	oracle = Oracle (
		'PAGESETUPDLG',
		'Nlllll2l4l4lllllll',
		('struct_size',
		 'owner',
		 'dev_mode',
		 'dev_names',
		 'flags',
		 'paper_size',
		 'min_margin',
		 'margin',
		 'instance',
		 'cust_data',
		 'page_setup_hook',
		 'page_paint_hook',
		 'page_setup_template_name',
		 'page_setup_template'
		 )
		)

# typedef struct tagPSD {  // psd  
#     DWORD           lStructSize; 
#     HWND            hwndOwner; 
#     HGLOBAL         hDevMode; 
#     HGLOBAL         hDevNames; 
#     DWORD           Flags; 
#     POINT           ptPaperSize; 
#     RECT            rtMinMargin; 
#     RECT            rtMargin; 
#     HINSTANCE       hInstance; 
#     LPARAM          lCustData; 
#     LPPAGESETUPHOOK lpfnPageSetupHook; 
#     LPPAGEPAINTHOOK lpfnPagePaintHook; 
#     LPCTSTR         lpPageSetupTemplateName; 
#     HGLOBAL         hPageSetupTemplate; 
# } PAGESETUPDLG, * LPPAGESETUPDLG; 
 

# from <commdlg.h>

PD_ALLPAGES                  = 0x00000000
PD_SELECTION                 = 0x00000001
PD_PAGENUMS                  = 0x00000002
PD_NOSELECTION               = 0x00000004
PD_NOPAGENUMS                = 0x00000008
PD_COLLATE                   = 0x00000010
PD_PRINTTOFILE               = 0x00000020
PD_PRINTSETUP                = 0x00000040
PD_NOWARNING                 = 0x00000080
PD_RETURNDC                  = 0x00000100
PD_RETURNIC                  = 0x00000200
PD_RETURNDEFAULT             = 0x00000400
PD_SHOWHELP                  = 0x00000800
PD_ENABLEPRINTHOOK           = 0x00001000
PD_ENABLESETUPHOOK           = 0x00002000
PD_ENABLEPRINTTEMPLATE       = 0x00004000
PD_ENABLESETUPTEMPLATE       = 0x00008000
PD_ENABLEPRINTTEMPLATEHANDLE = 0x00010000
PD_ENABLESETUPTEMPLATEHANDLE = 0x00020000
PD_USEDEVMODECOPIES          = 0x00040000
PD_USEDEVMODECOPIESANDCOLLATE = 0x00040000
PD_DISABLEPRINTTOFILE        = 0x00080000
PD_HIDEPRINTTOFILE           = 0x00100000
PD_NONETWORKBUTTON           = 0x00200000

import windll
comdlg32 = windll.module ('comdlg32')
gdi32 = windll.module ('gdi32')

import windc
import wingdi

class print_session:
	def __init__ (self, doc_name='untitled document'):
		pd = PRINTDLG()
		pd.flags = PD_RETURNDC
		pd.struct_size = pd._size

		di = wingdi.DOCINFO()
		dn = windll.cstring (doc_name)
		di.doc_name = dn.address()

		self.dn = dn
		self.di = di
		self.pd = pd

	def start (self):
		if comdlg32.PrintDlg (self.pd):
			dc = windc.DC (self.pd.dc)
		else:
			raise SystemError, "PrintDlg failed"

		dc.start_doc (self.di)
		self.dc = dc
		return dc

	def end (self):
		self.dc.end_doc()
		self.dc.delete_dc()
		del self.dc

def test2():
	ps = print_session ('testing')
	dc = ps.start()

	dc.start_page()
	dc.move_to ((0,0))
	dc.line_to ((100, 100))
	dc.end_page()

	ps.end()

if __name__ == '__main__':
	test2()
