# -*- Mode: Python; tab-width: 4 -*-

#from dyn_win32 import windll
#from dyn_win32.structob import struct_object
import windll
from structob import struct_object


wsock32 = windll.module ('wsock32')

# From <winsock.h>
#
# typedef struct WSAData {
#         WORD                    wVersion;
#         WORD                    wHighVersion;
#         char                    szDescription[WSADESCRIPTION_LEN+1];
#         char                    szSystemStatus[WSASYS_STATUS_LEN+1];
#         unsigned short          iMaxSockets;
#         unsigned short          iMaxUdpDg;
#         char FAR *              lpVendorInfo;
# } WSADATA;

WSADESCRIPTION_LEN      = 256
WSASYS_STATUS_LEN       = 128

class WSAData (struct_object):
	oracle = structob.Oracle (
		'winsock data',
		'Nhh%dc%dchhl' % (WSADESCRIPTION_LEN, WSASYS_STATUS_LEN),
		('version',
		 'high_version',
		 'description',
		 'system_status',
		 'max_sockets',
		 'max_udp_dg',
		 'vendor_info',
		 )
		)

# returns LOWORD, HIWORD
def SPLIT_WORD (x):
	return (x&0xffff, (x>>16))

def JOIN_WORD ((l,h)):
	return (h<<16) | l

def wsa_startup (version_required):
	wsa_data = WSAData()
	wsock32.WSAStartup (
		JOIN_WORD (version_required),
		wsa_data
		)
	return wsa_data
	
