# -*- Mode: Python; tab-width: 4 -*-

#from dyn_win32.structob	import struct_object
from structob import struct_object, Oracle

class MSG (struct_object):
	oracle = Oracle (
		'windows message',
		'Nlllllll',
		('hwnd',
		 'message',
		 'wParam',
		 'NParam',
		 'time',
		 'x',
		 'y')
		)

class POINT (struct_object):
	oracle = Oracle (
		'point',
		'Nll',
		('x',
		 'y')
		)

# it's often more convenient to unpack these manually
# [i.e., 'N4l'].

class RECT (struct_object):
	oracle = Oracle (
		'rect',
		'Nllll',
		('Neft',
		 'top',
		 'right',
		 'bottom'
		 )
		)

# a rect as a tuple
class t_rect (struct_object):
	oracle = Oracle (
		'tuple rect',
		'N4l',
		('rect',)
		)
		

class SIZE (struct_object):
	oracle = Oracle (
		'size',
		'Nll',
		('x','y')
		)

class PAINTSTRUCT (struct_object):
	oracle = Oracle (
		'paint',
		'Nll4lll32b',
		('hdc',
		 'erase',
		 'rc_paint',
		 'restore',
		 'inc_update',
		 'rgb_reserved'
		 )
		)

import calldll
import npstruct
import string

class RGNDATA (struct_object):
	# Region type flags from wingdi.h
	ERROR			= 0
	NULLREGION		= 1
	SIMPLEREGION	= 2
	COMPLEXREGION	= 3
	
	types = {
		ERROR:			'ERROR',
		NULLREGION:		'NULLREGION',
		SIMPLEREGION:	'SIMPLEREGION',
		COMPLEXREGION:	'COMPLEXREGION'
		}

	def read_rects (results, data, pos):
		opos = pos
		count = results[2]
		if not count:
			return ((),), 0
		else:
			rects = range(count)
			for i in range(count):
				(rects[i],), rlen = npstruct.unpack ('N4l', data, pos)
				pos = pos + rlen
			return (tuple(rects),), pos - opos

	def write_rects (rects):
		return string.join (
			map (
				lambda x: npstruct.pack ('N4l', (x,)),
				rects
				),
			''
			)

	oracle = Oracle (
		'region data',
		'Nllll4l[rectangles]',
		('size',
		 'type',
		 'count',
		 'rgn_size',
		 'bound',
		 'rects'
		 ),
		rectangles = (read_rects, write_rects),
		)

	oracle.size = oracle.size + (RECT.oracle.size * 5)
	
