/*
 * Decompiled with CFR 0.152.
 */
package openchat.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import openchat.client.About;
import openchat.client.InfoUser;
import openchat.client.MsgBox;
import openchat.client.MsgBoxReceive;

class ClientMain
extends Thread {
    private JFrame jFrame;
    private JButton InfoUser;
    private JButton SearchUser;
    private JButton LabelOnline;
    private JLabel LabelLastAccess;
    private JPanel Main;
    private JPanel Buttons;
    private JPanel LIST;
    private JPanel USERS;
    private JScrollPane UsersScroll;
    private JComboBox jComboStatus;
    private String HostServer;
    private String Token = "###";
    private String UserPassword;
    private int PortServer;
    private int PortClient;
    private int UserId;
    private int STATUS = 0;
    private Socket MSG;
    private BufferedReader Reply;
    private PrintWriter Send;
    private MOUSEClick MOUSE;
    private MouseListener mouseListener;
    private Vector ContactListId = new Vector();
    private Vector ContactListLogin = new Vector();
    private Vector ContactListIp = new Vector();
    private Vector MessageList = new Vector();
    static ImageIcon iconOnline = new ImageIcon("openchat/client/icons/online.png");
    static ImageIcon iconOffline = new ImageIcon("openchat/client/icons/offline.png");
    static ImageIcon iconMessage = new ImageIcon("openchat/client/icons/message.png");
    static ImageIcon iconFind = new ImageIcon("openchat/client/icons/url.png");
    static ImageIcon iconInfo = new ImageIcon("openchat/client/icons/chat.png");
    static ImageIcon iconAdd = new ImageIcon("openchat/client/icons/gnomeicu-ffc.png");
    static ImageIcon iconRem = new ImageIcon("openchat/client/icons/gnomeicu-occ.png");
    static ImageIcon iconSearch = new ImageIcon("openchat/client/icons/gnomeicu-url.png");
    static ImageIcon iconMy = new ImageIcon("openchat/client/icons/gnomeicu-file.png");
    static ImageIcon iconAbout = new ImageIcon("openchat/client/icons/gnomeicu-offline.png");
    static ImageIcon iconExit = new ImageIcon("openchat/client/icons/gnomeicu-dnd.png");
    static ImageIcon iconSend = new ImageIcon("openchat/client/icons/gnomeicu-ok.png");
    static ImageIcon iconClose = new ImageIcon("openchat/client/icons/gnomeicu-cancel.png");

    public ClientMain(String string, int n, int n2, int n3, String string2) {
        this.HostServer = new String(string);
        this.PortServer = n;
        this.PortClient = n2;
        this.UserId = n3;
        this.UserPassword = string2;
    }

    public void run() {
        this.jFrame = new JFrame();
        this.Main = new JPanel(new BorderLayout());
        this.Buttons = new JPanel(new GridLayout(3, 1));
        this.LIST = new JPanel(new GridLayout(0, 1, 0, 5));
        this.USERS = new JPanel(new BorderLayout(2, 5));
        this.USERS.add((Component)this.LIST, "First");
        this.UsersScroll = new JScrollPane(this.LIST);
        this.UsersScroll.setVerticalScrollBarPolicy(22);
        this.USERS.add("North", this.LIST);
        this.MOUSE = new MOUSEClick();
        this.GetListContact();
        this.LabelOnline = new JButton("Online");
        this.LabelLastAccess = new JLabel("");
        this.SearchUser = new JButton("Search for User", iconSearch);
        this.InfoUser = new JButton("Info User", iconInfo);
        String[] stringArray = new String[]{"All Users", "Online", "Offline"};
        this.jComboStatus = new JComboBox<String>(stringArray);
        this.jComboStatus.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ClientMain.this.STATUS = ClientMain.this.jComboStatus.getSelectedIndex();
                    ClientMain.this.GetListContact();
                }
            }
        });
        this.Buttons.add(this.jComboStatus);
        this.Buttons.add(this.InfoUser);
        this.Buttons.add(this.SearchUser);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.InfoUser.addActionListener(buttonHandler);
        this.SearchUser.addActionListener(buttonHandler);
        JMenu jMenu = new JMenu("Options");
        jMenu.setMnemonic('O');
        JMenu jMenu2 = new JMenu("Exit");
        jMenu.setMnemonic('E');
        JMenuItem jMenuItem = new JMenuItem("Add Contact", iconAdd);
        JMenuItem jMenuItem2 = new JMenuItem("Remove Contact", iconRem);
        JMenuItem jMenuItem3 = new JMenuItem("Info User", iconInfo);
        JMenuItem jMenuItem4 = new JMenuItem("Search for User", iconSearch);
        JMenuItem jMenuItem5 = new JMenuItem("My Info", iconMy);
        JMenuItem jMenuItem6 = new JMenuItem("About", iconAbout);
        JMenuItem jMenuItem7 = new JMenuItem("Exit", iconExit);
        jMenu2.addSeparator();
        jMenu2.add(jMenuItem7);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        jMenu.add(jMenuItem6);
        ClickMenuItems clickMenuItems = new ClickMenuItems();
        jMenuItem3.addActionListener(clickMenuItems);
        jMenuItem7.addActionListener(clickMenuItems);
        jMenuItem.addActionListener(clickMenuItems);
        jMenuItem2.addActionListener(clickMenuItems);
        jMenuItem4.addActionListener(clickMenuItems);
        jMenuItem6.addActionListener(clickMenuItems);
        jMenuItem5.addActionListener(clickMenuItems);
        JMenuBar jMenuBar = new JMenuBar();
        this.jFrame.setJMenuBar(jMenuBar);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.Main.add((Component)this.LabelOnline, "First");
        this.Main.add((Component)new JScrollPane(this.USERS), "Center");
        this.Main.add((Component)this.Buttons, "Last");
        this.jFrame.getContentPane().add(this.Main);
        this.jFrame.setTitle(this.UserId + " - OpenChat");
        this.jFrame.setLocation(844, 132);
        this.jFrame.setSize(170, 500);
        this.jFrame.setVisible(true);
        this.jFrame.show();
        this.jFrame.setDefaultCloseOperation(0);
        new StartInbox(this.PortClient).start();
    }

    public String ContactUser(String string, int n) {
        String string2 = "false";
        try {
            this.MSG = new Socket(this.HostServer, this.PortServer);
            this.Send = new PrintWriter(new OutputStreamWriter(this.MSG.getOutputStream()));
            this.Reply = new BufferedReader(new InputStreamReader(this.MSG.getInputStream()));
            this.Send.println(string + this.Token + this.UserId + this.Token + n + this.Token);
            this.Send.flush();
            string2 = this.Reply.readLine();
            this.Send.close();
            this.Reply.close();
            this.MSG.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Server down!\n\n" + exception.getMessage());
        }
        return string2;
    }

    public void Logout() {
        try {
            this.MSG = new Socket(this.HostServer, this.PortServer);
            this.Send = new PrintWriter(new OutputStreamWriter(this.MSG.getOutputStream()));
            this.Send.println("Logout" + this.Token + this.UserId + this.Token + this.UserPassword + this.Token);
            this.Send.flush();
            this.MSG.close();
            this.Send.close();
            this.ContactListId.clear();
            this.ContactListLogin.clear();
            this.ContactListIp.clear();
            this.LIST.removeAll();
            this.LIST.revalidate();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error :: Server offline or password is bad.\n\n" + exception.getMessage());
        }
    }

    private void GetListContact() {
        block6: {
            try {
                this.MSG = new Socket(this.HostServer, this.PortServer);
                this.Reply = new BufferedReader(new InputStreamReader(this.MSG.getInputStream()));
                this.Send = new PrintWriter(new OutputStreamWriter(this.MSG.getOutputStream()));
                String string = "ReturnContactList" + this.Token + this.UserId;
                this.Send.println(string);
                this.Send.flush();
                StringTokenizer stringTokenizer = new StringTokenizer(this.Reply.readLine(), this.Token);
                this.MSG.close();
                this.MSG = null;
                this.Reply.close();
                this.Reply = null;
                this.Send.close();
                this.Send = null;
                if (!stringTokenizer.nextToken().equals("ContactList")) break block6;
                try {
                    this.ContactListId.clear();
                    this.ContactListLogin.clear();
                    this.ContactListIp.clear();
                    this.ContactListIp.removeAllElements();
                    this.ContactListLogin.removeAllElements();
                    this.ContactListId.removeAllElements();
                    this.LIST.removeAll();
                    this.LIST.revalidate();
                    while (stringTokenizer.hasMoreTokens()) {
                        JLabel jLabel;
                        String string2 = new String(stringTokenizer.nextToken());
                        String string3 = new String(stringTokenizer.nextToken());
                        String string4 = new String(stringTokenizer.nextToken());
                        stringTokenizer.nextToken();
                        this.ContactListId.addElement(string2);
                        this.ContactListLogin.addElement(string3);
                        this.ContactListIp.addElement(string4);
                        if (!(this.STATUS != 1 && this.STATUS != 0 || string4.equals("0"))) {
                            jLabel = new JLabel(string3, iconOnline, 2);
                            this.LIST.add("Center", jLabel);
                            jLabel.addMouseListener(this.MOUSE);
                            jLabel.addMouseListener(this.mouseListener);
                        }
                        if (this.STATUS != 2 && this.STATUS != 0 || !string4.equals("0")) continue;
                        jLabel = new JLabel(string3, iconOffline, 2);
                        this.LIST.add("Center", jLabel);
                        jLabel.addMouseListener(this.MOUSE);
                        jLabel.addMouseListener(this.mouseListener);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Error in ContactList.\n\n" + exception.getMessage());
                    return;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error in ContactList.\n\n" + exception.getMessage());
                return;
            }
        }
    }

    class SearchUsers
    extends Thread {
        private JFrame jFrame;
        private JPanel jPanel;
        private JPanel jButtons;
        private JPanel jLists;
        private JPanel jLabels;
        private JButton ButtonSearch;
        private JButton ButtonClose;
        private JButton ButtonAdd;
        private JLabel LabelId;
        private JLabel LabelLogin;
        private JLabel LabelIp;
        private JLabel LabelSearch;
        private JList ListId;
        private JList ListLogin;
        private JList ListIp;
        private JComboBox ComboSearchFor;
        private String[] jComboSearchOptions = new String[]{"All Users", "Online Users"};
        private String Token = "###";
        private StringTokenizer UsersFound;
        private int OptionSearch = 0;
        private Vector UserIdFound;
        private Vector UserLoginFound;
        private Vector UserIpFound;

        SearchUsers() {
        }

        public void run() {
            this.jFrame = new JFrame();
            this.jPanel = new JPanel(new BorderLayout());
            this.jLists = new JPanel(new GridLayout(1, 3));
            this.jButtons = new JPanel(new GridLayout(1, 3));
            this.jLabels = new JPanel(new GridLayout(2, 3));
            this.ButtonSearch = new JButton("Search now", iconSend);
            this.ButtonClose = new JButton("Close", iconClose);
            this.ButtonAdd = new JButton("Add to list", iconAdd);
            this.jButtons.add(this.ButtonSearch);
            this.jButtons.add(this.ButtonAdd);
            this.jButtons.add(this.ButtonClose);
            ButtonClickSearch buttonClickSearch = new ButtonClickSearch();
            this.ButtonSearch.addActionListener(buttonClickSearch);
            this.ButtonClose.addActionListener(buttonClickSearch);
            this.ButtonAdd.addActionListener(buttonClickSearch);
            this.ComboSearchFor = new JComboBox<String>(this.jComboSearchOptions);
            this.ComboSearchFor.addItemListener(new ItemListener(this){
                private final /* synthetic */ SearchUsers this$1;
                {
                    this.this$1 = searchUsers;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SearchUsers.access$1302(this.this$1, SearchUsers.access$1400(this.this$1).getSelectedIndex());
                    }
                }
            });
            this.LabelSearch = new JLabel("User Search", 0);
            this.LabelSearch.setForeground(Color.BLUE);
            this.LabelId = new JLabel("  Id  ( select here )");
            this.LabelLogin = new JLabel("  Nick");
            this.LabelIp = new JLabel("  Ip");
            this.jLabels.add(new JLabel(""));
            this.jLabels.add(this.LabelSearch);
            this.jLabels.add(this.ComboSearchFor);
            this.jLabels.add(this.LabelId);
            this.jLabels.add(this.LabelLogin);
            this.jLabels.add(this.LabelIp);
            this.ListId = new JList();
            this.ListLogin = new JList();
            this.ListIp = new JList();
            this.jLists.add(this.ListId);
            this.jLists.add(this.ListLogin);
            this.jLists.add(this.ListIp);
            ItemSelect itemSelect = new ItemSelect();
            this.ListId.addListSelectionListener(itemSelect);
            this.ListIp.addListSelectionListener(itemSelect);
            this.ListLogin.addListSelectionListener(itemSelect);
            this.jPanel.add((Component)this.jLabels, "First");
            this.jPanel.add((Component)new JScrollPane(this.jLists), "Center");
            this.jPanel.add((Component)this.jButtons, "Last");
            this.jFrame.getContentPane().add(this.jPanel);
            this.jFrame.setTitle("Search for User - OpenChat");
            this.jFrame.setLocation(200, 259);
            this.jFrame.setSize(600, 250);
            this.jFrame.setVisible(true);
            this.jFrame.show();
            this.jFrame.setDefaultCloseOperation(0);
        }

        private void SearchNowUsers() {
            try {
                ClientMain.this.MSG = new Socket(ClientMain.this.HostServer, ClientMain.this.PortServer);
                ClientMain.this.Reply = new BufferedReader(new InputStreamReader(ClientMain.this.MSG.getInputStream()));
                ClientMain.this.Send = new PrintWriter(new OutputStreamWriter(ClientMain.this.MSG.getOutputStream()));
                try {
                    String string = "ReturnUsers" + this.Token + this.OptionSearch + this.Token;
                    ClientMain.this.Send.println(string);
                    ClientMain.this.Send.flush();
                    this.UsersFound = new StringTokenizer(ClientMain.this.Reply.readLine(), this.Token);
                    this.UserIdFound = new Vector();
                    this.UserIpFound = new Vector();
                    this.UserLoginFound = new Vector();
                    this.UsersFound.nextToken();
                    while (this.UsersFound.hasMoreTokens()) {
                        String string2 = new String(this.UsersFound.nextToken());
                        String string3 = new String(this.UsersFound.nextToken());
                        String string4 = new String(this.UsersFound.nextToken());
                        this.UsersFound.nextToken();
                        if (string3.length() > 25) {
                            string3 = string3.substring(0, 25) + "...";
                        }
                        this.UserIdFound.addElement(string2);
                        this.UserLoginFound.addElement(string3);
                        this.UserIpFound.addElement(string4);
                    }
                    this.ListId.clearSelection();
                    this.ListLogin.clearSelection();
                    this.ListIp.clearSelection();
                    this.ListId.setListData(this.UserIdFound);
                    this.ListLogin.setListData(this.UserLoginFound);
                    this.ListIp.setListData(this.UserIpFound);
                }
                catch (Exception exception) {
                    System.out.println("erro ao procurar nego" + exception.getMessage());
                }
                ClientMain.this.Reply.close();
                ClientMain.this.Send.close();
                ClientMain.this.MSG.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "\nError in communication with server!\nServer online?", "Warning", 2);
                return;
            }
        }

        static /* synthetic */ int access$1302(SearchUsers searchUsers, int n) {
            searchUsers.OptionSearch = n;
            return searchUsers.OptionSearch;
        }

        static /* synthetic */ JComboBox access$1400(SearchUsers searchUsers) {
            return searchUsers.ComboSearchFor;
        }

        class ButtonClickSearch
        implements ActionListener {
            ButtonClickSearch() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Search now")) {
                    SearchUsers.this.SearchNowUsers();
                }
                if (actionEvent.getActionCommand().equals("Close")) {
                    SearchUsers.this.jFrame.dispose();
                }
                if (actionEvent.getActionCommand().equals("Add to list")) {
                    if (SearchUsers.this.ListId.isSelectionEmpty()) {
                        JOptionPane.showMessageDialog(null, "\n Select the Id of contact.");
                    } else if (ClientMain.this.ContactUser("AddContact", Integer.parseInt("" + SearchUsers.this.UserIdFound.get(SearchUsers.this.ListId.getSelectedIndex()))).equals("true")) {
                        JOptionPane.showMessageDialog(null, "\n Contact User added !");
                        ClientMain.this.GetListContact();
                    } else {
                        JOptionPane.showMessageDialog(null, "\n Contact exist in you list.");
                    }
                }
            }
        }

        class ItemSelect
        implements ListSelectionListener {
            ItemSelect() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!SearchUsers.this.ListId.isSelectionEmpty()) {
                    SearchUsers.this.ListLogin.setSelectedIndex(SearchUsers.this.ListId.getSelectedIndex());
                    SearchUsers.this.ListIp.setSelectedIndex(SearchUsers.this.ListId.getSelectedIndex());
                } else if (!SearchUsers.this.ListLogin.isSelectionEmpty() || !SearchUsers.this.ListIp.isSelectionEmpty()) {
                    SearchUsers.this.ListLogin.clearSelection();
                    SearchUsers.this.ListIp.clearSelection();
                }
            }
        }
    }

    class StartInbox
    extends Thread {
        private ServerSocket ServerMessage;
        private Socket Inbox;
        private StringTokenizer MSG;
        private BufferedReader E;
        private String Confirm;
        private int IdFrom;
        private int PortClient;
        private ClientMain clientMain;

        public StartInbox(int n) {
            this.PortClient = n;
        }

        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(this.PortClient);
                while (true) {
                    Socket socket = serverSocket.accept();
                    this.NewMessage(socket);
                }
            }
            catch (Exception exception) {
                System.err.println("Erro: canal de comunicacao::CLIENTEOPENCHAT");
                return;
            }
        }

        private void NewMessage(Socket socket) {
            block11: {
                try {
                    JLabel jLabel = new JLabel();
                    this.Inbox = socket;
                    this.E = new BufferedReader(new InputStreamReader(this.Inbox.getInputStream()));
                    this.MSG = new StringTokenizer(this.E.readLine(), "###");
                    this.Confirm = new String(this.MSG.nextToken());
                    if (this.Confirm.equals("UpdateList")) {
                        ClientMain.this.GetListContact();
                    }
                    if (!this.Confirm.equals("NewMessage")) break block11;
                    this.IdFrom = Integer.parseInt(this.MSG.nextToken());
                    String string = "";
                    try {
                        while (true) {
                            string = string + this.E.readLine();
                            if (this.E.ready()) {
                                string = string + '\n';
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("ERRO NO FOR CLIENT :" + exception.getMessage());
                    }
                    boolean bl = false;
                    for (int i = 0; i < ClientMain.this.LIST.getComponentCount(); ++i) {
                        if (Integer.parseInt("" + ClientMain.this.ContactListId.get(i)) != this.IdFrom) continue;
                        jLabel = (JLabel)ClientMain.this.LIST.getComponent(i);
                        jLabel.setForeground(Color.BLUE);
                        jLabel.repaint();
                        jLabel.setIcon(iconMessage);
                        ClientMain.this.MessageList.addElement("MessageTo" + ClientMain.this.Token + this.IdFrom);
                        ClientMain.this.MessageList.addElement(string);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        new MsgBoxReceive(this.IdFrom, new String("" + this.IdFrom), this.Inbox.getInetAddress().getHostAddress(), string).start();
                    }
                }
                catch (Exception exception) {
                    System.out.println("errrooooo");
                    System.out.println(exception.getMessage());
                }
            }
            try {
                this.E.close();
                this.Inbox.close();
            }
            catch (Exception exception) {
                System.out.println("erro ao close do client");
            }
        }
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Info User")) {
                if (ClientMain.this.LabelLastAccess.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "\nSelect the User Contact.");
                } else {
                    for (int i = 0; i < ClientMain.this.ContactListId.size(); ++i) {
                        if (!ClientMain.this.ContactListLogin.get(i).equals(ClientMain.this.LabelLastAccess.getText())) continue;
                        boolean bl = false;
                        new InfoUser(ClientMain.this.HostServer, ClientMain.this.PortServer, "" + ClientMain.this.ContactListId.get(i), bl).start();
                        break;
                    }
                }
            }
            if (actionEvent.getActionCommand().equals("Search for User")) {
                new SearchUsers().start();
            }
        }
    }

    class MOUSEClick
    extends MouseAdapter {
        MOUSEClick() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!ClientMain.this.LabelLastAccess.equals("")) {
                ClientMain.this.LabelLastAccess.setForeground(Color.BLACK);
            }
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            ClientMain.this.LabelLastAccess = jLabel;
            String string = new String("");
            int n = 0;
            for (int i = 0; i < ClientMain.this.ContactListLogin.size(); ++i) {
                if (jLabel.getText().equals(ClientMain.this.ContactListLogin.get(i)) && mouseEvent.getClickCount() == 2) {
                    if (jLabel.getIcon() == iconMessage) {
                        jLabel.setIcon(iconOnline);
                        block1: for (int j = 0; j < ClientMain.this.MessageList.size(); ++j) {
                            for (int k = 0; k < ClientMain.this.MessageList.size(); ++k) {
                                if (!("MessageTo" + ClientMain.this.Token + ClientMain.this.ContactListId.get(i)).equals(ClientMain.this.MessageList.get(k))) continue;
                                n = i;
                                ClientMain.this.MessageList.removeElementAt(k);
                                string = string + ClientMain.this.MessageList.get(k) + ClientMain.this.Token;
                                ClientMain.this.MessageList.removeElementAt(k);
                                j = 0;
                                continue block1;
                            }
                        }
                        new MsgBoxReceive(Integer.parseInt("" + ClientMain.this.ContactListId.get(n)), "" + ClientMain.this.ContactListLogin.get(n), "" + ClientMain.this.ContactListIp.get(n), string).start();
                        break;
                    }
                    jLabel.setForeground(Color.BLACK);
                    jLabel.repaint();
                    new MsgBox(ClientMain.this.HostServer, ClientMain.this.PortServer, ClientMain.this.UserId, ClientMain.this.ContactListId.get(i), ClientMain.this.ContactListLogin.get(i), ClientMain.this.ContactListIp.get(i)).start();
                    break;
                }
                if (!jLabel.getText().equals(ClientMain.this.ContactListLogin.get(i)) || mouseEvent.getClickCount() != 1) continue;
                jLabel.setForeground(Color.BLUE);
                jLabel.repaint();
            }
        }
    }

    public class ClickMenuItems
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (actionEvent.getActionCommand().equals("About")) {
                About about = new About();
            }
            if (actionEvent.getActionCommand().equals("Logout")) {
                ClientMain.this.Logout();
            }
            if (actionEvent.getActionCommand().equals("Exit")) {
                ClientMain.this.Logout();
                System.exit(0);
            }
            if (actionEvent.getActionCommand().equals("My Info")) {
                boolean bl2 = true;
                new InfoUser(ClientMain.this.HostServer, ClientMain.this.PortServer, "" + ClientMain.this.UserId, bl2).start();
            }
            if (actionEvent.getActionCommand().equals("Info User")) {
                if (ClientMain.this.LabelLastAccess.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "\nSelect the User Contact.");
                } else {
                    for (int i = 0; i < ClientMain.this.ContactListId.size(); ++i) {
                        if (!ClientMain.this.ContactListLogin.get(i).equals(ClientMain.this.LabelLastAccess.getText())) continue;
                        bl = false;
                        new InfoUser(ClientMain.this.HostServer, ClientMain.this.PortServer, "" + ClientMain.this.ContactListId.get(i), bl).start();
                        break;
                    }
                }
            }
            if (actionEvent.getActionCommand().equals("Add Contact")) {
                int n = 0;
                try {
                    String string = JOptionPane.showInputDialog("What is ID of the New Contact User ?");
                    if (string == null) {
                        return;
                    }
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "\nThe value of ID is invalid. (only integer)\n");
                    return;
                }
                if (ClientMain.this.ContactUser("AddContact", n).equals("true")) {
                    JOptionPane.showMessageDialog(null, "\n Contact User added !");
                    ClientMain.this.GetListContact();
                } else {
                    JOptionPane.showMessageDialog(null, "\n Contact: \n    - Not found\n    - Contact exist");
                }
            }
            if (actionEvent.getActionCommand().equals("Remove Contact")) {
                int n = 0;
                bl = false;
                if (ClientMain.this.LabelLastAccess.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "\nSelect the User Contact.");
                } else {
                    n = JOptionPane.showConfirmDialog(null, "Remove the user :  " + ClientMain.this.LabelLastAccess.getText(), "Remove Uset - OpenChat", 0);
                    if (n != 1) {
                        for (int i = 0; i < ClientMain.this.ContactListLogin.size(); ++i) {
                            if (!ClientMain.this.LabelLastAccess.getText().equals(ClientMain.this.ContactListLogin.get(i))) continue;
                            n = Integer.parseInt("" + ClientMain.this.ContactListId.get(i));
                            break;
                        }
                        if (ClientMain.this.ContactUser("DeleteContact", n).equals("true")) {
                            JOptionPane.showMessageDialog(null, "\n Contact User removed !");
                            ClientMain.this.GetListContact();
                            ClientMain.this.LabelLastAccess.setText("");
                        } else {
                            JOptionPane.showMessageDialog(null, "\n Contact: \n    - Not found\n    - Contact exist");
                        }
                    }
                }
            }
            if (actionEvent.getActionCommand().equals("Search for User")) {
                new SearchUsers().start();
            }
        }
    }
}

